/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.inventory.operator.client;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.config.Operation;
import dev.terminalmc.clientsort.client.interaction.InteractionManager;
import dev.terminalmc.clientsort.client.inventory.operator.client.ClientOperator;
import dev.terminalmc.clientsort.client.util.SoundManager;
import dev.terminalmc.clientsort.util.inject.ISlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ClientCreativeOperator
extends ClientOperator {
    public ClientCreativeOperator(AbstractContainerScreen<?> screen, Slot originSlot, Operation op) {
        super(screen, originSlot, op);
    }

    @Override
    protected void collect() {
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation COLLECT: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (ClientSort.debug()) {
            ClientSort.LOG.info("Starting operation COLLECT", new Object[0]);
        }
        block0: for (int i = this.originScopeSlots.length - 1; i >= 0; --i) {
            Slot srcSlot = this.originScopeSlots[i];
            ItemStack srcStack = this.originScopeStacks[i];
            if (srcStack.m_41619_() || srcStack.m_41613_() >= srcSlot.m_5866_(srcStack)) continue;
            for (int j = 0; j < i; ++j) {
                Slot dstSlot = this.originScopeSlots[j];
                ItemStack dstStack = this.originScopeStacks[j];
                if (dstStack.m_41619_() || dstStack.m_41613_() >= dstSlot.m_5866_(dstStack) || !ItemStack.m_150942_((ItemStack)srcStack, (ItemStack)dstStack)) continue;
                int delta = dstSlot.m_5866_(dstStack) - dstStack.m_41613_();
                delta = Math.min(delta, srcStack.m_41613_());
                srcStack.m_41774_(delta);
                dstStack.m_41769_(delta);
                int srcSlotId = ((ISlot)srcSlot).clientsort$getIndexInMenu();
                int dstSlotId = ((ISlot)dstSlot).clientsort$getIndexInMenu();
                InteractionManager.push(() -> {
                    Minecraft.m_91087_().f_91072_.m_105241_(srcStack.m_41777_(), srcSlotId);
                    Minecraft.m_91087_().f_91072_.m_105241_(dstStack.m_41777_(), dstSlotId);
                    return InteractionManager.TICK_WAITER;
                });
                if (srcStack.m_41613_() <= 0) continue block0;
            }
        }
        InteractionManager.push(() -> {
            Minecraft.m_91087_().f_91074_.f_36095_.m_38946_();
            if (ClientSort.debug()) {
                ClientSort.LOG.info("Finished operation COLLECT", new Object[0]);
            }
            return InteractionManager.TICK_WAITER;
        });
    }

    @Override
    protected void sort(int[] key, boolean playSound) {
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation SORT: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (ClientSort.debug()) {
            ClientSort.LOG.info("Starting operation SORT", new Object[0]);
        }
        for (int i = 0; i < key.length; ++i) {
            ItemStack srcItem = this.originScopeStacks[key[i]];
            ItemStack dstItem = this.originScopeStacks[i];
            if (srcItem.m_41619_() && dstItem.m_41619_()) continue;
            int dstSlotId = ((ISlot)this.originScopeSlots[i]).clientsort$getIndexInMenu();
            InteractionManager.push(() -> {
                Minecraft.m_91087_().f_91074_.f_36095_.m_38853_(dstSlotId).m_5852_(srcItem);
                Minecraft.m_91087_().f_91072_.m_105241_(srcItem, dstSlotId);
                if (playSound) {
                    SoundManager.play();
                }
                return InteractionManager.TICK_WAITER;
            });
        }
        InteractionManager.push(() -> {
            Minecraft.m_91087_().f_91074_.f_36095_.m_38946_();
            if (ClientSort.debug()) {
                ClientSort.LOG.info("Finished operation SORT", new Object[0]);
            }
            return InteractionManager.TICK_WAITER;
        });
    }

    @Override
    protected void fillStacks() {
        if (ClientSort.debug()) {
            ClientSort.LOG.warn("Operation STACK_FILL is not supported by {}", this.getClass().getSimpleName());
        }
    }

    @Override
    protected void matchTransfer() {
        if (ClientSort.debug()) {
            ClientSort.LOG.warn("Operation MATCH_TRANSFER is not supported by {}", this.getClass().getSimpleName());
        }
    }

    @Override
    protected void transfer() {
        if (ClientSort.debug()) {
            ClientSort.LOG.warn("Operation TRANSFER is not supported by {}", this.getClass().getSimpleName());
        }
    }
}

