/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.torch_hit.handler;

import it.crystalnest.cobweb.api.item.ItemUtils;
import it.crystalnest.torch_hit.Constants;
import it.crystalnest.torch_hit.compat.SoulFired;
import it.crystalnest.torch_hit.config.ModConfig;
import it.crystalnest.torch_hit.platform.Services;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import org.jetbrains.annotations.Nullable;

public abstract class AttackHandler {
    protected AttackHandler() {
    }

    protected static void handle(Entity entity, Entity directEntity, LivingEntity target) {
        if (entity instanceof LivingEntity) {
            InteractionHand interactionHand;
            LivingEntity attacker = (LivingEntity)entity;
            if (entity.equals((Object)directEntity) && !entity.m_9236_().f_46443_ && !entity.m_5833_() && AttackHandler.canAttack(attacker, target) && (interactionHand = AttackHandler.getInteractionHand(attacker)) != null && !target.m_5825_()) {
                boolean directHit;
                ItemStack item = attacker.m_21120_(interactionHand);
                boolean bl = directHit = interactionHand == InteractionHand.MAIN_HAND;
                if (directHit || AttackHandler.isAllowedTool(attacker.m_21205_().m_41720_())) {
                    AttackHandler.attack(attacker, (Entity)target, item, directHit);
                }
            }
        }
    }

    private static void attack(LivingEntity attacker, Entity target, ItemStack item, boolean directHit) {
        AttackHandler.consumeItem(attacker, item, directHit, AttackHandler.torchHit(target, item, directHit ? ModConfig.getDirectHitDuration() : ModConfig.getIndirectHitDuration()));
    }

    private static void consumeItem(LivingEntity attacker, ItemStack item, boolean directHit, int seconds) {
        Player player;
        if (!(attacker instanceof Player) || !(player = (Player)attacker).m_7500_()) {
            if ((AttackHandler.isCandle(item) && ModConfig.getConsumeCandle().booleanValue() || AttackHandler.isTorch(item) && ModConfig.getConsumeTorch().booleanValue()) && (directHit || ModConfig.getConsumeWithIndirectHits().booleanValue()) && (ModConfig.getConsumeWithoutFire().booleanValue() || seconds > 0)) {
                item.m_41774_(1);
            } else {
                TieredItem tieredItem;
                Item item2 = attacker.m_21205_().m_41720_();
                if (item2 instanceof TieredItem && (tieredItem = (TieredItem)item2).m_43314_() == Tiers.WOOD && ModConfig.getIndirectHitToolDamage() > 0) {
                    attacker.m_21205_().m_41622_((tieredItem.m_41462_() * ModConfig.getIndirectHitToolDamage() + 99) / 100, attacker, livingEntity -> livingEntity.m_21190_(InteractionHand.MAIN_HAND));
                }
            }
        }
    }

    private static int torchHit(Entity target, ItemStack item, int defaultSeconds) {
        int seconds = AttackHandler.getFireSeconds(item, target, defaultSeconds);
        if (seconds > 0) {
            if (Services.PLATFORM.isModLoaded("soul_fire_d")) {
                SoulFired.setOnFire(item, target, seconds);
            } else {
                target.m_20254_(seconds);
            }
        }
        return seconds;
    }

    private static int getFireSeconds(ItemStack item, Entity target, int seconds) {
        if (Math.random() * 100.0 < (double)ModConfig.getFireChance().intValue()) {
            if (Services.PLATFORM.isModLoaded("soul_fire_d")) {
                return seconds;
            }
            if (Constants.isSoulTorch(item)) {
                return target instanceof AbstractPiglin ? seconds * 2 : seconds + 2;
            }
            return seconds;
        }
        return 0;
    }

    private static boolean isAllowedTool(Item item) {
        return !ModConfig.getIndirectHitToolList().isEmpty() && ModConfig.getIndirectHitToolList().stream().anyMatch(toolType -> ItemUtils.getKey((Item)item).toString().matches(".*:([^_]+_)*" + toolType + "(_[^_]+)*"));
    }

    @Nullable
    private static InteractionHand getInteractionHand(LivingEntity attacker) {
        if (AttackHandler.isValidItem(attacker.m_21205_())) {
            return InteractionHand.MAIN_HAND;
        }
        if (AttackHandler.isValidItem(attacker.m_21206_())) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    private static boolean isValidItem(ItemStack item) {
        return AttackHandler.isTorch(item) || AttackHandler.isCandle(item);
    }

    private static boolean isTorch(ItemStack item) {
        return item.m_150930_(Items.f_42000_) && ModConfig.getVanillaTorchesEnabled() != false || ModConfig.getExtraTorchItems().contains(ItemUtils.getKey((Item)item.m_41720_()).toString()) || Constants.isSoulTorch(item);
    }

    private static boolean isCandle(ItemStack item) {
        return ModConfig.getAllowCandles() != false && item.m_204117_(ItemTags.f_144319_);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean canAttack(LivingEntity attacker, LivingEntity target) {
        if (!(attacker instanceof Player)) {
            if (ModConfig.getFireFromMobs() == false) return false;
        }
        if (!attacker.m_6779_(target)) return false;
        if (!(attacker instanceof Player)) return true;
        Player attackerPlayer = (Player)attacker;
        if (!(target instanceof Player)) return true;
        Player targetPlayer = (Player)target;
        if (!attackerPlayer.m_7099_(targetPlayer)) return false;
        return true;
    }
}

