/*
 * Decompiled with CFR 0.152.
 */
package com.hisroyalty.hrbsdrills.entity;

import com.google.common.collect.Lists;
import com.hisroyalty.hrbsdrills.Config;
import com.hisroyalty.hrbsdrills.DrillsMod;
import com.hisroyalty.hrbsdrills.container.DrillContainer;
import com.hisroyalty.hrbsdrills.sound.SoundRegistry;
import java.util.ArrayList;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DrillEntity
extends Entity
implements GeoEntity,
MenuProvider {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public boolean isMoving = this.m_20096_() && this.m_20184_().m_165925_() > 1.0E-9;
    private boolean breakableBlocks;
    public double speedMultiplier = 0.0;
    public static final EntityDataAccessor<Integer> MAX_HEALTH = SynchedEntityData.m_135353_(DrillEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> HEALTH = SynchedEntityData.m_135353_(DrillEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> PROGRESS = SynchedEntityData.m_135353_(DrillEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MAX_PROGRESS = SynchedEntityData.m_135353_(DrillEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> WPROGRESS = SynchedEntityData.m_135353_(DrillEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MAX_WPROGRESS = SynchedEntityData.m_135353_(DrillEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> NETHERITE = SynchedEntityData.m_135353_(DrillEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float previousRotationYaw;
    private final ItemStackHandler itemHandler = new ItemStackHandler(3);
    public final LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    public int accelerationTime;
    public int timeInVehicle;
    public float yrot;
    private boolean inputLeft;
    private boolean inputRight;
    private boolean inputUp;
    private boolean inputDown;
    protected float deltaRotation;
    private Vec3 previousPosition = Vec3.f_82478_;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;

    public DrillEntity(EntityType<? extends DrillEntity> entityType, Level world) {
        super(entityType, world);
    }

    public InteractionResult m_7111_(Player player, Vec3 hitPos, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == Items.f_42791_ && !this.getNetherite()) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            this.f_19804_.m_135381_(NETHERITE, (Object)true);
        } else if (this.m_7310_((Entity)player)) {
            PlayerInteractEvent.EntityInteract event = new PlayerInteractEvent.EntityInteract(player, hand, (Entity)this);
            if (!this.m_9236_().f_46443_ && !MinecraftForge.EVENT_BUS.post((Event)event)) {
                player.m_7998_((Entity)this, false);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public void center() {
        Direction facing = this.m_6350_();
        switch (facing) {
            case SOUTH: {
                this.m_146922_(0.0f);
                break;
            }
            case NORTH: {
                this.m_146922_(180.0f);
                break;
            }
            case EAST: {
                this.m_146922_(-90.0f);
                break;
            }
            case WEST: {
                this.m_146922_(90.0f);
            }
        }
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
        super.m_7840_(pY, pOnGround, pState, pPos);
    }

    public Vec3 m_7688_(LivingEntity pLivingEntity) {
        Vec3 vec3 = DrillEntity.m_19903_((double)(this.m_20205_() * Mth.f_13994_), (double)pLivingEntity.m_20205_(), (float)pLivingEntity.m_146908_());
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20189_() + vec3.f_82481_;
        BlockPos blockpos = BlockPos.m_274561_((double)d0, (double)this.m_20191_().f_82292_, (double)d1);
        BlockPos blockpos1 = blockpos.m_7495_();
        if (!this.m_9236_().m_46801_(blockpos1)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = this.m_9236_().m_45573_(blockpos);
            if (DismountHelper.m_38439_((double)d2)) {
                list.add(new Vec3(d0, (double)blockpos.m_123342_() + d2, d1));
            }
            if (DismountHelper.m_38439_((double)(d3 = this.m_9236_().m_45573_(blockpos1)))) {
                list.add(new Vec3(d0, (double)blockpos1.m_123342_() + d3, d1));
            }
            for (Pose pose : pLivingEntity.m_7431_()) {
                for (Vec3 vec31 : list) {
                    if (!DismountHelper.m_150279_((CollisionGetter)this.m_9236_(), (Vec3)vec31, (LivingEntity)pLivingEntity, (Pose)pose)) continue;
                    pLivingEntity.m_20124_(pose);
                    return vec31;
                }
            }
        }
        return super.m_7688_(pLivingEntity);
    }

    protected void m_20348_(Entity pPassenger) {
        super.m_20348_(pPassenger);
        if (this.m_6109_() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.m_19890_(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYRot, (float)this.lerpXRot);
        }
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
    }

    public int m_6056_() {
        return 30;
    }

    public void m_7334_(Entity pEntity) {
        super.m_7334_(pEntity);
        LivingEntity entity = (LivingEntity)pEntity;
        LivingEntity rider = this.m_6688_();
        if (this.m_217005_() && pEntity != rider) {
            Player playerRider = (Player)rider;
            assert (playerRider != null);
            if (this.m_6688_() instanceof Player) {
                entity.m_6469_(this.m_269291_().m_269075_((Player)this.m_6688_()), (float)this.accelerationTime / 10.0f);
            }
        }
    }

    public int getProgress() {
        return (Integer)this.f_19804_.m_135370_(PROGRESS);
    }

    public void setProgress(int progress) {
        this.f_19804_.m_135381_(PROGRESS, (Object)progress);
    }

    public int getWProgress() {
        return (Integer)this.f_19804_.m_135370_(WPROGRESS);
    }

    public void setWProgress(int wprogress) {
        this.f_19804_.m_135381_(WPROGRESS, (Object)wprogress);
    }

    public int getMaxProgress() {
        return (Integer)this.f_19804_.m_135370_(MAX_PROGRESS);
    }

    public void setMaxProgress(int maxProgress) {
        this.f_19804_.m_135381_(MAX_PROGRESS, (Object)maxProgress);
    }

    public int getMaxWProgress() {
        return (Integer)this.f_19804_.m_135370_(MAX_WPROGRESS);
    }

    public void setMaxWProgress(int maxWProgress) {
        this.f_19804_.m_135381_(MAX_WPROGRESS, (Object)maxWProgress);
    }

    public boolean isBreakableBlock(BlockState blockstate) {
        return blockstate.m_204336_(BlockTags.f_144282_) || blockstate.m_204336_(BlockTags.f_144283_);
    }

    private void destroyBlocks() {
        Vec3 facing = Vec3.m_82503_((Vec2)this.m_20155_());
        double floatingHeight = 0.5;
        Vec3 floatingOffset = new Vec3(0.0, 0.5, 0.0);
        AABB box = this.m_20191_().m_82383_(facing.m_82541_().m_82549_(floatingOffset));
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            BlockPos.m_121921_((AABB)box).forEach(blockPos -> {
                BlockState blockstate = this.m_9236_().m_8055_(blockPos);
                if (!this.m_9236_().m_7966_(p, blockPos)) {
                    return;
                }
                BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(this.m_9236_(), blockPos, blockstate, p);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    Level patt14013$temp = this.m_9236_();
                    if (patt14013$temp instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)patt14013$temp;
                        serverLevel.m_7260_(blockPos, blockstate, blockstate, 3);
                    }
                    return;
                }
                if (ForgeHooks.canEntityDestroy((Level)this.m_9236_(), (BlockPos)blockPos, (LivingEntity)p) && this.isBreakableBlock(blockstate) && blockstate.m_60815_()) {
                    this.m_9236_().m_46953_(blockPos, ((Boolean)Config.DROP_BLOCK.get()).booleanValue(), (Entity)p);
                }
            });
        }
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)inventory);
    }

    public boolean shouldRiderSit() {
        return false;
    }

    protected void m_19956_(Entity pPassenger, Entity.MoveFunction pCallback) {
        super.m_19956_(pPassenger, pCallback);
    }

    public Iterable<ItemStack> m_6168_() {
        return null;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
    }

    public void setInput(boolean pInputLeft, boolean pInputRight, boolean pInputUp, boolean pInputDown) {
        this.inputLeft = pInputLeft;
        this.inputRight = pInputRight;
        this.inputUp = pInputUp;
        this.inputDown = pInputDown;
    }

    private void control() {
        if (this.m_20160_() && this.m_217005_() && this.getProgress() > 0) {
            double gravity = 0.875;
            double upwardForce = 0.5;
            if (!this.m_20096_()) {
                Vec3 motion = this.m_20184_();
                this.m_20334_(motion.f_82479_, motion.f_82480_ - gravity, motion.f_82481_);
            }
            LivingEntity livingEntity = this.m_6688_();
            if (this.m_6688_() == livingEntity) {
                double moveX = 0.0;
                double moveY = 0.0;
                double moveZ = 0.0;
                if (this.m_217005_()) {
                    if (this.inputLeft) {
                        this.m_146922_(this.m_146908_() - 1.0f);
                    }
                    if (this.inputRight) {
                        this.m_146922_(this.m_146908_() + 1.0f);
                    }
                    double yawRad = Math.toRadians(this.m_146908_());
                    double x = -Math.sin(yawRad);
                    double z = Math.cos(yawRad);
                    if (this.inputUp) {
                        moveX += this.getWProgress() > 0 ? x * 0.1 : x * 0.025;
                        moveZ += this.getWProgress() > 0 ? z * 0.1 : z * 0.025;
                    }
                    if (this.inputDown) {
                        moveX -= this.getWProgress() > 0 ? x * 0.1 : x * 0.025;
                        moveZ -= this.getWProgress() > 0 ? z * 0.1 : z * 0.025;
                    }
                    Vec3 deltaMovement = new Vec3(moveX, moveY, moveZ);
                    Vec3 currentDeltaMovement = this.m_20184_();
                    Vec3 updatedDeltaMovement = currentDeltaMovement.m_82549_(deltaMovement);
                    if (!this.f_19862_) {
                        this.m_20256_(updatedDeltaMovement);
                    } else if (this.m_20096_()) {
                        this.m_20256_(updatedDeltaMovement.m_82520_(0.0, upwardForce, 0.0));
                    }
                }
            } else {
                this.m_146922_(this.m_146908_());
            }
        }
    }

    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        } else if (this.lerpSteps > 0) {
            this.m_6034_(this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps, this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps, this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps);
            this.m_146922_((float)((double)this.m_146908_() + Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_())) / (double)this.lerpSteps));
            --this.lerpSteps;
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!player.m_6144_()) {
            if (player.m_20202_() == this || !this.m_9236_().f_46443_) {
                // empty if block
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void m_8119_() {
        if (this.m_217005_() && this.getNetherite()) {
            Player player = (Player)this.m_6688_();
            player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 20, 1));
        }
        if (!this.m_9236_().f_46443_) {
            ItemStack itemStack;
            int itemBurnTime;
            ItemStack waterStack;
            if (this.getWProgress() > 0) {
                this.setWProgress(this.getWProgress() - 1);
            } else if (this.m_6084_() && (waterStack = this.itemHandler.getStackInSlot(0)).m_150930_(Items.f_42447_)) {
                this.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)Items.f_42446_));
                this.setWProgress(8000);
                this.setMaxWProgress(8000);
            }
            if (this.getProgress() > 0) {
                this.setProgress(this.getProgress() - Config.fuelEfficiency);
            } else if (this.m_6084_() && (itemBurnTime = ForgeHooks.getBurnTime((ItemStack)(itemStack = this.itemHandler.getStackInSlot(1)), null)) > 0) {
                this.setProgress(itemBurnTime);
                this.setMaxProgress(itemBurnTime);
                if (itemStack.hasCraftingRemainingItem()) {
                    this.itemHandler.setStackInSlot(1, itemStack.getCraftingRemainingItem());
                } else {
                    this.itemHandler.extractItem(1, 1, false);
                }
            }
            this.f_19854_ = this.m_20185_();
            this.f_19855_ = this.m_20186_();
            this.f_19856_ = this.m_20189_();
        }
        this.setAnimData(DataTickets.ACTIVE, true);
        super.m_8119_();
        this.tickLerp();
        this.m_20256_(Vec3.f_82478_);
        this.yrot = this.m_146908_();
        if (!this.m_20184_().equals((Object)Vec3.f_82478_) || !this.m_20182_().equals((Object)this.previousPosition)) {
            this.previousPosition = this.m_20182_();
        }
        if (this.m_146908_() != this.previousRotationYaw) {
            this.previousRotationYaw = this.m_146908_();
        }
        if (this.m_6109_()) {
            if (this.m_9236_().f_46443_) {
                this.control();
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        } else {
            this.m_20256_(Vec3.f_82478_);
        }
        if (this.m_20160_()) {
            ++this.timeInVehicle;
        }
        this.destroyBlocks();
    }

    public void m_6453_(double pX, double pY, double pZ, float pYRot, float pXRot, int pLerpSteps, boolean pTeleport) {
        this.lerpX = pX;
        this.lerpY = pY;
        this.lerpZ = pZ;
        this.lerpYRot = pYRot;
        this.lerpXRot = pXRot;
        this.lerpSteps = this.m_6095_().m_20682_() + 1;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(HEALTH, (Object)100);
        this.f_19804_.m_135372_(MAX_HEALTH, (Object)100);
        this.f_19804_.m_135372_(PROGRESS, (Object)0);
        this.f_19804_.m_135372_(MAX_PROGRESS, (Object)0);
        this.f_19804_.m_135372_(WPROGRESS, (Object)0);
        this.f_19804_.m_135372_(MAX_WPROGRESS, (Object)0);
        this.f_19804_.m_135372_(NETHERITE, (Object)false);
    }

    @Nullable
    public ItemStack m_142340_() {
        return ((Item)DrillsMod.DRILL.get()).m_7968_();
    }

    public void setHealth(int health) {
        this.f_19804_.m_135381_(HEALTH, (Object)Math.max(health, 0));
    }

    public int getHealth() {
        return (Integer)this.f_19804_.m_135370_(HEALTH);
    }

    public void setNetherite(boolean netherite) {
        this.f_19804_.m_135381_(NETHERITE, (Object)netherite);
    }

    public boolean getNetherite() {
        return (Boolean)this.f_19804_.m_135370_(NETHERITE);
    }

    public int getMaxHealth() {
        return (Integer)this.f_19804_.m_135370_(MAX_HEALTH);
    }

    public void m_7378_(CompoundTag pCompound) {
        this.itemHandler.deserializeNBT(pCompound.m_128469_("inventory"));
        if (pCompound.m_128441_("max_health")) {
            int maxHealth = pCompound.m_128451_("max_health");
            if (maxHealth <= 0) {
                maxHealth = 20;
            }
            this.f_19804_.m_135381_(MAX_HEALTH, (Object)maxHealth);
        }
        if (pCompound.m_128441_("health")) {
            int health = pCompound.m_128451_("health");
            this.f_19804_.m_135381_(HEALTH, (Object)health);
        }
        if (pCompound.m_128441_("progress")) {
            this.setProgress(pCompound.m_128451_("progress"));
        }
        if (pCompound.m_128441_("maxProgress")) {
            this.setMaxProgress(pCompound.m_128451_("maxProgress"));
        }
        if (pCompound.m_128441_("wprogress")) {
            this.setWProgress(pCompound.m_128451_("wprogress"));
        }
        if (pCompound.m_128441_("maxWProgress")) {
            this.setMaxWProgress(pCompound.m_128451_("maxWProgress"));
        }
        if (pCompound.m_128441_("netherite")) {
            this.f_19804_.m_135381_(NETHERITE, (Object)pCompound.m_128471_("netherite"));
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        pCompound.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pCompound.m_128405_("health", ((Integer)this.f_19804_.m_135370_(HEALTH)).intValue());
        pCompound.m_128405_("max_health", ((Integer)this.f_19804_.m_135370_(MAX_HEALTH)).intValue());
        pCompound.m_128405_("progress", this.getProgress());
        pCompound.m_128405_("maxProgress", this.getMaxProgress());
        pCompound.m_128405_("wprogress", this.getWProgress());
        pCompound.m_128405_("maxWProgress", this.getMaxWProgress());
        pCompound.m_128379_("netherite", ((Boolean)this.f_19804_.m_135370_(NETHERITE)).booleanValue());
    }

    public ItemStack getItemStack() {
        ItemStack itemStack = this.getItem().m_7968_();
        CompoundTag compound = new CompoundTag();
        this.m_7380_(compound);
        compound.m_128405_("health", ((Integer)this.f_19804_.m_135370_(MAX_HEALTH)).intValue());
        compound.m_128379_("netherite", ((Boolean)this.f_19804_.m_135370_(NETHERITE)).booleanValue());
        itemStack.m_41700_("Compound", (Tag)compound);
        return itemStack;
    }

    protected void dropItem() {
        ItemStack itemStack = this.getItemStack();
        this.m_19983_(itemStack);
    }

    protected Item getItem() {
        return (Item)DrillsMod.DRILL.get();
    }

    public float getStepHeight() {
        return 1.0f;
    }

    public boolean m_5825_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Player player;
        AttackEntityEvent event;
        Entity entity = pSource.m_7639_();
        if (entity instanceof Player && MinecraftForge.EVENT_BUS.post((Event)(event = new AttackEntityEvent(player = (Player)entity, (Entity)this)))) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && this.getHealth() <= 0) {
            this.m_6074_();
            this.dropItem();
            this.drops();
            this.m_142467_(Entity.RemovalReason.KILLED);
            return true;
        }
        pAmount = 3.0f;
        if (pSource.m_269415_() == this.m_9236_().m_269111_().m_269325_().m_269415_() || pSource.m_269415_() == this.m_9236_().m_269111_().m_269555_().m_269415_()) {
            return false;
        }
        if (this.getNetherite() && (pSource.m_269415_() == this.m_9236_().m_269111_().m_269233_().m_269415_() || pSource.m_269415_() == this.m_9236_().m_269111_().m_269387_().m_269415_() || pSource.m_269415_() == this.m_9236_().m_269111_().m_269549_().m_269415_())) {
            return false;
        }
        if (pSource == this.m_9236_().m_269111_().m_269063_()) {
            return false;
        }
        if (pSource.m_269415_() == this.m_9236_().m_269111_().m_269325_().m_269415_() || pSource.m_269415_() == this.m_9236_().m_269111_().m_269555_().m_269415_()) {
            return false;
        }
        this.setHealth((int)((float)((Integer)this.f_19804_.m_135370_(HEALTH)).intValue() - pAmount));
        return super.m_6469_(pSource, pAmount);
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_((SoundEvent)SoundRegistry.DRILL.get(), Config.vol, Config.pitch);
    }

    protected void m_20351_(Entity pPassenger) {
        super.m_20351_(pPassenger);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 1, this::predicate)});
    }

    protected <E extends GeoAnimatable> PlayState predicate(AnimationState<E> event) {
        if (this.f_19854_ != this.m_20185_() || this.f_19856_ != this.m_20189_()) {
            if (this.getNetherite()) {
                event.getController().setAnimation(RawAnimation.begin().then("drill_v5", Animation.LoopType.LOOP));
            } else {
                event.getController().setAnimation(RawAnimation.begin().then("drill_v1", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Nullable
    public LivingEntity m_6688_() {
        return this.m_20197_().isEmpty() ? null : (LivingEntity)this.m_20197_().get(0);
    }

    protected Vec3 m_7643_(Direction.Axis pAxis, BlockUtil.FoundRectangle pPortal) {
        return LivingEntity.m_21289_((Vec3)super.m_7643_(pAxis, pPortal));
    }

    public void m_8127_() {
        super.m_8127_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new DrillContainer(pContainerId, pPlayerInventory, this);
    }
}

