/*
 * Decompiled with CFR 0.152.
 */
package com.hisroyalty.hrbsdrills;

import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="hrbsdrills", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.BooleanValue DROP_BLOCK = BUILDER.comment("Whether to drop blocks when drilling").define("dropBlock", true);
    public static final ForgeConfigSpec.IntValue FUEL_EFFICIENCY = BUILDER.comment("Fuel efficiency of the drill. Bigger the value, the less efficient the drill is.").defineInRange("fuelEfficiency", 12, 1, Integer.MAX_VALUE);
    public static final ForgeConfigSpec.DoubleValue VOL = BUILDER.comment("Volume of the Drilling Sound.").defineInRange("volume", 0.25, 0.0, 2.147483647E9);
    public static final ForgeConfigSpec.DoubleValue PITCH = BUILDER.comment("Pitch of the Drilling Sound.").defineInRange("pitch", 1.0, 0.0, 2.147483647E9);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean dropBlock;
    public static int fuelEfficiency;
    public static float vol;
    public static float pitch;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemName = (String)obj));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        dropBlock = (Boolean)DROP_BLOCK.get();
        fuelEfficiency = (Integer)FUEL_EFFICIENCY.get();
        vol = ((Double)VOL.get()).floatValue();
        pitch = ((Double)PITCH.get()).floatValue();
    }
}

