/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.base.tag_utils;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.world.level.material.Fluid;
import rbasamoyai.createbigcannons.base.tag_utils.TypeAndTagDataHolder;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;

public class FluidTypeDataHolder<VALUE>
extends TypeAndTagDataHolder<Fluid, VALUE> {
    private final Map<Fluid, VALUE> cachedData = new Reference2ObjectOpenHashMap();
    private final Set<Fluid> noData = new ReferenceOpenHashSet();

    public FluidTypeDataHolder() {
        super(CBCRegistryUtils.getFluidRegistry());
    }

    @Override
    public void cleanUp() {
        this.cachedData.clear();
        this.noData.clear();
        super.cleanUp();
    }

    @Override
    public void cleanUpTags() {
        this.cachedData.clear();
        this.noData.clear();
        super.cleanUpTags();
    }

    @Override
    @Nullable
    public VALUE getData(Fluid fluid) {
        if (this.noData.contains(fluid)) {
            return null;
        }
        if (this.cachedData.containsKey(fluid)) {
            return this.cachedData.get(fluid);
        }
        Object result = super.getData(fluid);
        if (result != null) {
            return result;
        }
        for (Map.Entry entry : this.typeData.entrySet()) {
            if (!((Fluid)entry.getKey()).m_6212_(fluid)) continue;
            Object found = entry.getValue();
            this.cachedData.put(fluid, found);
            return (VALUE)found;
        }
        for (Map.Entry entry : this.tagData.entrySet()) {
            if (!((Fluid)entry.getKey()).m_6212_(fluid)) continue;
            Object found = entry.getValue();
            this.cachedData.put(fluid, found);
            return (VALUE)found;
        }
        this.noData.add(fluid);
        return null;
    }
}

