/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.worldgen;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.StrangeMatterMod;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class WorldGenUtils {
    public static boolean isSolidGround(BlockState state) {
        return state.m_60815_() && !state.m_60795_();
    }

    public static boolean isSurfaceBlock(BlockState state) {
        return state.m_60713_(Blocks.f_50125_) || state.m_60713_(Blocks.f_50050_) || state.m_60713_(Blocks.f_50054_) || state.m_60713_(Blocks.f_50052_) || state.m_60713_(Blocks.f_50055_) || state.m_60713_(Blocks.f_50053_) || state.m_60713_(Blocks.f_50051_) || state.m_60713_(Blocks.f_271115_) || state.m_60713_(Blocks.f_220838_);
    }

    public static boolean isSuitableForAnomalousGrass(BlockState state) {
        return true;
    }

    public static boolean isActualGround(BlockState state) {
        if (!state.m_60815_() || state.m_60795_()) {
            return false;
        }
        return !WorldGenUtils.isSurfaceBlock(state);
    }

    public static BlockPos findSolidGround(WorldGenLevel level, BlockPos startPos) {
        BlockPos pos = startPos;
        int minY = level.m_141937_() + 10;
        while (pos.m_123342_() > minY) {
            BlockState state = level.m_8055_(pos);
            if (WorldGenUtils.isSolidGround(state)) {
                return pos;
            }
            pos = pos.m_7495_();
        }
        return null;
    }

    public static SurfaceInfo findSurfaceAndGround(WorldGenLevel level, int x, int z) {
        int surfaceY = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
        BlockPos surfacePos = new BlockPos(x, surfaceY, z);
        BlockPos groundPos = WorldGenUtils.findSolidGround(level, surfacePos);
        if (groundPos == null) {
            return null;
        }
        return new SurfaceInfo(surfacePos, groundPos);
    }

    public static BlockPos findAnomalousGrassPosition(WorldGenLevel level, int x, int z) {
        int surfaceY = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
        BlockPos surfacePos = new BlockPos(x, surfaceY, z);
        BlockState surfaceState = level.m_8055_(surfacePos);
        if (WorldGenUtils.isActualGround(surfaceState)) {
            return surfacePos;
        }
        BlockPos currentPos = surfacePos;
        int minY = level.m_141937_() + 10;
        while (currentPos.m_123342_() > minY) {
            BlockState state = level.m_8055_(currentPos = currentPos.m_7495_());
            if (!WorldGenUtils.isActualGround(state)) continue;
            return currentPos;
        }
        return null;
    }

    public static void placeAnomalousGrassPatch(WorldGenLevel level, BlockPos origin, int radius, float chance, RandomSource random) {
        if (!Config.enableAnomalousGrass) {
            return;
        }
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos grassPos;
                double distance = Math.sqrt(x * x + z * z);
                if (!(distance <= (double)radius) || !(random.m_188501_() < chance) || (grassPos = WorldGenUtils.findAnomalousGrassPosition(level, origin.m_123341_() + x, origin.m_123343_() + z)) == null) continue;
                level.m_7731_(grassPos, ((Block)StrangeMatterMod.ANOMALOUS_GRASS_BLOCK.get()).m_49966_(), 3);
            }
        }
    }

    public static void placeAnomalyOres(WorldGenLevel level, BlockPos origin, int radius, RandomSource random, Block shardOreBlock) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                double distance = Math.sqrt(x * x + z * z);
                if (!(distance <= (double)radius)) continue;
                BlockPos columnStart = origin.m_7918_(x, -1, z);
                WorldGenUtils.placeOreColumn(level, columnStart, random, ((Block)StrangeMatterMod.RESONITE_ORE_BLOCK.get()).m_49966_(), Config.resoniteOreSpawnChanceNearAnomaly);
                WorldGenUtils.placeOreColumn(level, columnStart, random, shardOreBlock.m_49966_(), Config.shardOreSpawnChanceNearAnomaly);
            }
        }
    }

    private static void placeOreColumn(WorldGenLevel level, BlockPos startPos, RandomSource random, BlockState oreState, double chance) {
        if (startPos == null || oreState == null || chance <= 0.0) {
            return;
        }
        if (random.m_188500_() >= chance) {
            return;
        }
        BlockPos basePos = WorldGenUtils.findFirstReplaceableOreBlock(level, startPos);
        if (basePos == null) {
            return;
        }
        int minY = level.m_141937_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(basePos.m_123341_(), basePos.m_123342_(), basePos.m_123343_());
        int columnLength = 1 + random.m_188503_(3);
        int placed = 0;
        while (placed < columnLength && mutable.m_123342_() >= minY) {
            BlockState state = level.m_8055_((BlockPos)mutable);
            if (!WorldGenUtils.canReplaceWithOre(state)) {
                if (placed != 0) break;
                mutable.m_122184_(0, -1, 0);
                continue;
            }
            BlockPos placePos = mutable.m_7949_();
            level.m_7731_(placePos, oreState, 3);
            ++placed;
            mutable.m_122184_(0, -1, 0);
        }
    }

    private static BlockPos findFirstReplaceableOreBlock(WorldGenLevel level, BlockPos startPos) {
        if (startPos == null || level == null) {
            return null;
        }
        int minY = level.m_141937_();
        int maxY = Math.min(startPos.m_123342_(), level.m_151558_() - 1);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(startPos.m_123341_(), maxY, startPos.m_123343_());
        for (int y = maxY; y >= minY; --y) {
            mutable.m_122178_(startPos.m_123341_(), y, startPos.m_123343_());
            BlockState state = level.m_8055_((BlockPos)mutable);
            if (state.m_60795_() || !WorldGenUtils.canReplaceWithOre(state)) continue;
            return mutable.m_7949_();
        }
        return null;
    }

    private static boolean canReplaceWithOre(BlockState state) {
        return Config.anomalyOreReplacementBlocks.contains(state.m_60734_());
    }

    public static class SurfaceInfo {
        public final BlockPos surfacePos;
        public final BlockPos groundPos;

        public SurfaceInfo(BlockPos surfacePos, BlockPos groundPos) {
            this.surfacePos = surfacePos;
            this.groundPos = groundPos;
        }
    }
}

