/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.worldgen;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.StrangeMatterMod;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class WarpGateAnomalyStructure
extends Structure {
    public static final Codec<WarpGateAnomalyStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)WarpGateAnomalyStructure.m_226567_((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, WarpGateAnomalyStructure::new));

    public WarpGateAnomalyStructure(Structure.StructureSettings config) {
        super(config);
    }

    public Optional<Structure.GenerationStub> m_214086_(@Nonnull Structure.GenerationContext context) {
        if (!Config.enableWarpGate) {
            return Optional.empty();
        }
        if (context.f_226626_().m_188503_(Config.warpGateRarity) != 0) {
            return Optional.empty();
        }
        ChunkPos chunkPos = context.f_226628_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(chunkPos.m_45604_() + context.f_226626_().m_188503_(16), 0, chunkPos.m_45605_() + context.f_226626_().m_188503_(16));
        int surfaceY = context.f_226622_().m_214096_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, context.f_226629_(), context.f_226624_());
        if (surfaceY < context.f_226629_().m_141937_() + 10 || surfaceY > context.f_226629_().m_151558_() - 10) {
            return Optional.empty();
        }
        Holder biome = context.f_226623_().m_203407_(pos.m_123341_() >> 2, pos.m_123342_() >> 2, pos.m_123343_() >> 2, context.f_226624_().m_224579_());
        String biomeName = biome.m_203543_().map(key -> key.m_135782_().toString()).orElse("unknown");
        if (biomeName.contains("ocean") || biomeName.contains("river") || biomeName.contains("beach") || biomeName.contains("deep_ocean") || biomeName.contains("lukewarm_ocean") || biomeName.contains("cold_ocean") || biomeName.contains("frozen_ocean") || biomeName.contains("warm_ocean")) {
            return Optional.empty();
        }
        pos.m_142448_(surfaceY);
        boolean spaceAbove1 = context.f_226622_().m_214184_(pos.m_123341_(), pos.m_123343_(), context.f_226629_(), context.f_226624_()).m_183556_(pos.m_123342_() + 1).m_60795_();
        boolean spaceAbove2 = context.f_226622_().m_214184_(pos.m_123341_(), pos.m_123343_(), context.f_226629_(), context.f_226624_()).m_183556_(pos.m_123342_() + 2).m_60795_();
        if (spaceAbove1 && spaceAbove2) {
            return Optional.of(new Structure.GenerationStub(pos.m_6630_(2), builder -> this.generateWarpGate((StructurePiecesBuilder)builder, pos.m_6630_(2))));
        }
        return Optional.empty();
    }

    private void generateWarpGate(StructurePiecesBuilder builder, BlockPos pos) {
    }

    public StructureType<?> m_213658_() {
        return (StructureType)StrangeMatterMod.WARP_GATE_ANOMALY_STRUCTURE.get();
    }
}

