/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.worldgen;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.block.AnomalySpawnerMarkerBlock;
import com.hexvane.strangematter.worldgen.BaseAnomalyConfiguredFeature;
import com.hexvane.strangematter.worldgen.WorldGenUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.registries.RegistryObject;

public class ThoughtwellConfiguredFeature
extends BaseAnomalyConfiguredFeature {
    public boolean m_142674_(@Nonnull FeaturePlaceContext<NoneFeatureConfiguration> context) {
        AnomalySpawnerMarkerBlock markerBlock;
        BlockState markerState;
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        WorldGenUtils.SurfaceInfo surfaceInfo = WorldGenUtils.findSurfaceAndGround(level, origin.m_123341_(), origin.m_123343_());
        if (surfaceInfo == null) {
            return false;
        }
        int anomalyY = surfaceInfo.surfacePos.m_123342_() + 2 + random.m_188503_(3);
        BlockPos anomalyPos = new BlockPos(origin.m_123341_(), anomalyY, origin.m_123343_());
        if (!level.m_7731_(anomalyPos, markerState = (BlockState)((BlockState)(markerBlock = (AnomalySpawnerMarkerBlock)((Object)StrangeMatterMod.ANOMALY_SPAWNER_MARKER_BLOCK.get())).m_49966_().m_61124_(AnomalySpawnerMarkerBlock.TYPE, (Comparable)((Object)AnomalySpawnerMarkerBlock.SpawnType.COGNITIVE))).m_61124_((Property)AnomalySpawnerMarkerBlock.ATTEMPTS, (Comparable)Integer.valueOf(0)), 3)) {
            return false;
        }
        level.m_186460_(anomalyPos, (Block)markerBlock, 1);
        this.placeAnomalousGrass(level, origin, random);
        this.placeOres(level, origin, random);
        this.placeCognitiveTerrain(level, origin, random);
        return true;
    }

    private void placeCognitiveTerrain(WorldGenLevel level, BlockPos origin, RandomSource random) {
        int radius = this.getTerrainModificationRadius();
        float chance = this.getGrassPlacementChance();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos abovePos;
                BlockState currentState;
                BlockPos surfacePos;
                double distance = Math.sqrt(x * x + z * z);
                if (!(distance <= (double)radius) || !(random.m_188501_() < chance) || (surfacePos = WorldGenUtils.findAnomalousGrassPosition(level, origin.m_123341_() + x, origin.m_123343_() + z)) == null || !WorldGenUtils.isActualGround(currentState = level.m_8055_(surfacePos)) || !(random.m_188501_() < 0.4f) || !level.m_8055_(abovePos = surfacePos.m_7494_()).m_60795_()) continue;
                if (random.m_188501_() < 0.5f) {
                    level.m_7731_(abovePos, Blocks.f_50078_.m_49966_(), 3);
                    continue;
                }
                if (!(random.m_188501_() < 0.3f)) continue;
                int deltaX = origin.m_123341_() - abovePos.m_123341_();
                int deltaZ = origin.m_123343_() - abovePos.m_123343_();
                Direction facing = Math.abs(deltaX) > Math.abs(deltaZ) ? (deltaX > 0 ? Direction.WEST : Direction.EAST) : (deltaZ > 0 ? Direction.NORTH : Direction.SOUTH);
                level.m_7731_(abovePos, (BlockState)Blocks.f_50624_.m_49966_().m_61124_((Property)LecternBlock.f_54465_, (Comparable)facing), 3);
            }
        }
    }

    @Override
    protected RegistryObject<Block> getShardOreBlock() {
        return StrangeMatterMod.INSIGHT_SHARD_ORE_BLOCK;
    }
}

