/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.worldgen;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.StrangeMatterMod;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class ConfiguredRarityFilter
extends PlacementModifier {
    public static final Codec<ConfiguredRarityFilter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("feature_type").forGetter(filter -> filter.featureType)).apply((Applicative)instance, ConfiguredRarityFilter::new));
    private final String featureType;

    public ConfiguredRarityFilter(String featureType) {
        this.featureType = featureType;
    }

    public Stream<BlockPos> m_213676_(@Nonnull PlacementContext context, @Nonnull RandomSource random, @Nonnull BlockPos pos) {
        int rarity;
        Integer overrideRarity;
        if (!this.isFeatureEnabled()) {
            return Stream.empty();
        }
        String currentDimension = this.getDimensionId(context);
        Integer n = overrideRarity = currentDimension != null ? this.getDimensionOverride(currentDimension) : null;
        if (!this.isDimensionAllowed(currentDimension, overrideRarity)) {
            return Stream.empty();
        }
        int n2 = rarity = overrideRarity != null ? overrideRarity.intValue() : this.getBaseRarity();
        if (rarity <= 0) {
            return Stream.empty();
        }
        if (random.m_188503_(rarity) == 0) {
            return Stream.of(pos);
        }
        return Stream.empty();
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)StrangeMatterMod.CONFIGURED_RARITY_FILTER.get();
    }

    private int getBaseRarity() {
        try {
            return switch (this.featureType) {
                case "gravity_anomaly" -> Config.gravityAnomalyRarity;
                case "temporal_bloom" -> Config.temporalBloomRarity;
                case "warp_gate_anomaly" -> Config.warpGateRarity;
                case "energetic_rift" -> Config.energeticRiftRarity;
                case "echoing_shadow" -> Config.echoingShadowRarity;
                case "thoughtwell" -> Config.thoughtwellRarity;
                default -> 500;
            };
        }
        catch (Exception e) {
            return 500;
        }
    }

    private boolean isFeatureEnabled() {
        try {
            return switch (this.featureType) {
                case "gravity_anomaly" -> Config.enableGravityAnomaly;
                case "temporal_bloom" -> Config.enableTemporalBloom;
                case "warp_gate_anomaly" -> Config.enableWarpGate;
                case "energetic_rift" -> Config.enableEnergeticRift;
                case "echoing_shadow" -> Config.enableEchoingShadow;
                case "thoughtwell" -> Config.enableThoughtwell;
                default -> true;
            };
        }
        catch (Exception e) {
            return true;
        }
    }

    private String getDimensionId(PlacementContext context) {
        try {
            return context.m_191831_().m_6018_().m_46472_().m_135782_().toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isDimensionAllowed(String dimensionId, Integer overrideRarity) {
        if (overrideRarity != null) {
            return overrideRarity > 0;
        }
        if (dimensionId == null) {
            return true;
        }
        List<String> allowedDimensions = this.getDimensionsFromConfig();
        if (allowedDimensions == null || allowedDimensions.isEmpty()) {
            return true;
        }
        return allowedDimensions.contains(dimensionId);
    }

    private Integer getDimensionOverride(String dimensionId) {
        if (dimensionId == null || dimensionId.isEmpty()) {
            return null;
        }
        Map<String, Integer> overrides = this.getDimensionRarityOverrides();
        if (overrides == null || overrides.isEmpty()) {
            return null;
        }
        Integer value = overrides.get(dimensionId);
        if (value != null) {
            return value;
        }
        return overrides.get("*");
    }

    private Map<String, Integer> getDimensionRarityOverrides() {
        try {
            return switch (this.featureType) {
                case "gravity_anomaly" -> Config.gravityAnomalyDimensionRarities;
                case "temporal_bloom" -> Config.temporalBloomDimensionRarities;
                case "warp_gate_anomaly" -> Config.warpGateDimensionRarities;
                case "energetic_rift" -> Config.energeticRiftDimensionRarities;
                case "echoing_shadow" -> Config.echoingShadowDimensionRarities;
                case "thoughtwell" -> Config.thoughtwellDimensionRarities;
                default -> Collections.emptyMap();
            };
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    private List<String> getDimensionsFromConfig() {
        try {
            return switch (this.featureType) {
                case "gravity_anomaly" -> Config.gravityAnomalyDimensions;
                case "temporal_bloom" -> Config.temporalBloomDimensions;
                case "warp_gate_anomaly" -> Config.warpGateDimensions;
                case "energetic_rift" -> Config.energeticRiftDimensions;
                case "echoing_shadow" -> Config.echoingShadowDimensions;
                case "thoughtwell" -> Config.thoughtwellDimensions;
                default -> null;
            };
        }
        catch (Exception e) {
            return null;
        }
    }
}

