/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.worldgen;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.StrangeMatterMod;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class ConfiguredCountPlacement
extends PlacementModifier {
    public static final Codec<ConfiguredCountPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("feature_type").forGetter(filter -> filter.featureType)).apply((Applicative)instance, ConfiguredCountPlacement::new));
    private final String featureType;

    public ConfiguredCountPlacement(String featureType) {
        this.featureType = featureType;
    }

    public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
        int count = this.getCountFromConfig();
        if (!this.isFeatureEnabled()) {
            return Stream.empty();
        }
        return Stream.generate(() -> pos).limit(count);
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)StrangeMatterMod.CONFIGURED_COUNT_PLACEMENT.get();
    }

    private int getCountFromConfig() {
        try {
            return switch (this.featureType) {
                case "resonite_ore" -> Config.resoniteOreVeinsPerChunk;
                default -> 3;
            };
        }
        catch (Exception e) {
            return 3;
        }
    }

    private boolean isFeatureEnabled() {
        return switch (this.featureType) {
            case "resonite_ore" -> Config.enableResoniteOre;
            default -> true;
        };
    }
}

