/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.worldgen;

import com.hexvane.strangematter.Config;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public record ConfiguredBiomeModifier(HolderSet<Biome> biomes, Holder<PlacedFeature> feature, GenerationStep.Decoration step, String featureType) implements BiomeModifier
{
    public static final Codec<ConfiguredBiomeModifier> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(ConfiguredBiomeModifier::biomes), (App)PlacedFeature.f_191773_.fieldOf("feature").forGetter(ConfiguredBiomeModifier::feature), (App)GenerationStep.Decoration.f_224188_.fieldOf("step").forGetter(ConfiguredBiomeModifier::step), (App)Codec.STRING.fieldOf("feature_type").forGetter(ConfiguredBiomeModifier::featureType)).apply((Applicative)builder, ConfiguredBiomeModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && this.biomes.m_203333_(biome) && this.isFeatureEnabled()) {
            builder.getGenerationSettings().m_255419_(this.step, this.feature);
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return CODEC;
    }

    private boolean isFeatureEnabled() {
        return switch (this.featureType) {
            case "gravity_anomaly" -> Config.enableGravityAnomaly;
            case "temporal_bloom" -> Config.enableTemporalBloom;
            case "warp_gate_anomaly" -> Config.enableWarpGate;
            case "energetic_rift" -> Config.enableEnergeticRift;
            case "echoing_shadow" -> Config.enableEchoingShadow;
            case "thoughtwell" -> Config.enableThoughtwell;
            case "resonite_ore" -> Config.enableResoniteOre;
            default -> true;
        };
    }
}

