/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.worldgen;

import com.hexvane.strangematter.Config;
import com.mojang.logging.LogUtils;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="strangematter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ConfigurableFeaturePlacement {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        Registry placedFeatures = event.getServer().m_206579_().m_175515_(Registries.f_256988_);
        ConfigurableFeaturePlacement.updateAnomalyRarity((Registry<PlacedFeature>)placedFeatures, "gravity_anomaly", Config.gravityAnomalyRarity, Config.enableGravityAnomaly);
        ConfigurableFeaturePlacement.updateAnomalyRarity((Registry<PlacedFeature>)placedFeatures, "temporal_bloom", Config.temporalBloomRarity, Config.enableTemporalBloom);
        ConfigurableFeaturePlacement.updateAnomalyRarity((Registry<PlacedFeature>)placedFeatures, "warp_gate_anomaly", Config.warpGateRarity, Config.enableWarpGate);
        ConfigurableFeaturePlacement.updateAnomalyRarity((Registry<PlacedFeature>)placedFeatures, "energetic_rift", Config.energeticRiftRarity, Config.enableEnergeticRift);
        ConfigurableFeaturePlacement.updateAnomalyRarity((Registry<PlacedFeature>)placedFeatures, "echoing_shadow", Config.echoingShadowRarity, Config.enableEchoingShadow);
        ConfigurableFeaturePlacement.updateAnomalyRarity((Registry<PlacedFeature>)placedFeatures, "thoughtwell", Config.thoughtwellRarity, Config.enableThoughtwell);
        ConfigurableFeaturePlacement.updateOreGeneration((Registry<PlacedFeature>)placedFeatures, "resonite_ore", Config.resoniteOreVeinsPerChunk, Config.enableResoniteOre);
    }

    private static void updateAnomalyRarity(Registry<PlacedFeature> registry, String featureName, int rarity, boolean enabled) {
        if (!enabled) {
            LOGGER.info("Feature {} is disabled in config", (Object)featureName);
        }
    }

    private static void updateOreGeneration(Registry<PlacedFeature> registry, String featureName, int veinsPerChunk, boolean enabled) {
        if (!enabled) {
            LOGGER.info("Ore feature {} is disabled in config", (Object)featureName);
        }
    }
}

