/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.worldgen;

import com.hexvane.strangematter.worldgen.WorldGenUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.registries.RegistryObject;

public abstract class BaseAnomalyConfiguredFeature
extends Feature<NoneFeatureConfiguration> {
    public BaseAnomalyConfiguredFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    protected abstract RegistryObject<Block> getShardOreBlock();

    protected int getTerrainModificationRadius() {
        return 5;
    }

    protected float getGrassPlacementChance() {
        return 0.8f;
    }

    protected void placeAnomalousGrass(WorldGenLevel level, BlockPos origin, RandomSource random) {
        int radius = this.getTerrainModificationRadius();
        float chance = this.getGrassPlacementChance();
        WorldGenUtils.placeAnomalousGrassPatch(level, origin, radius, chance, random);
    }

    protected void placeOres(WorldGenLevel level, BlockPos origin, RandomSource random) {
        int radius = this.getTerrainModificationRadius();
        WorldGenUtils.placeAnomalyOres(level, origin, radius, random, (Block)this.getShardOreBlock().get());
    }
}

