/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.util;

import com.hexvane.strangematter.entity.BaseAnomalyEntity;
import com.hexvane.strangematter.entity.EnergeticRiftEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AnomalyUtil {
    public static Optional<EnergeticRiftEntity> findNearestEnergeticRift(Level level, BlockPos pos, double radius) {
        Vec3 centerPos = Vec3.m_82512_((Vec3i)pos);
        double diameter = radius * 2.0;
        AABB searchArea = AABB.m_165882_((Vec3)centerPos, (double)diameter, (double)diameter, (double)diameter);
        List rifts = level.m_45976_(EnergeticRiftEntity.class, searchArea);
        EnergeticRiftEntity nearest = null;
        double nearestDistance = radius + 1.0;
        for (EnergeticRiftEntity rift : rifts) {
            double distance = centerPos.m_82554_(rift.m_20182_());
            if (!(distance <= radius) || !(distance < nearestDistance)) continue;
            nearest = rift;
            nearestDistance = distance;
        }
        return Optional.ofNullable(nearest);
    }

    public static Optional<BaseAnomalyEntity> findNearestAnomaly(Level level, BlockPos pos, double radius) {
        Vec3 centerPos = Vec3.m_82512_((Vec3i)pos);
        double diameter = radius * 2.0;
        AABB searchArea = AABB.m_165882_((Vec3)centerPos, (double)diameter, (double)diameter, (double)diameter);
        List anomalies = level.m_45976_(BaseAnomalyEntity.class, searchArea);
        BaseAnomalyEntity nearest = null;
        double nearestDistance = radius + 1.0;
        for (BaseAnomalyEntity anomaly : anomalies) {
            double distance = centerPos.m_82554_(anomaly.m_20182_());
            if (!(distance <= radius) || !(distance < nearestDistance)) continue;
            nearest = anomaly;
            nearestDistance = distance;
        }
        return Optional.ofNullable(nearest);
    }

    public static int countEnergeticRiftsInRange(Level level, BlockPos pos, double radius) {
        Vec3 centerPos = Vec3.m_82512_((Vec3i)pos);
        double diameter = radius * 2.0;
        AABB searchArea = AABB.m_165882_((Vec3)centerPos, (double)diameter, (double)diameter, (double)diameter);
        List rifts = level.m_45976_(EnergeticRiftEntity.class, searchArea);
        int count = 0;
        for (EnergeticRiftEntity rift : rifts) {
            double distance = centerPos.m_82554_(rift.m_20182_());
            if (!(distance <= radius)) continue;
            ++count;
        }
        return count;
    }

    public static boolean hasEnergeticRiftInRange(Level level, BlockPos pos, double radius) {
        return AnomalyUtil.findNearestEnergeticRift(level, pos, radius).isPresent();
    }
}

