/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.research;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.research.ResearchType;
import com.hexvane.strangematter.research.ScannableObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class ScannableObjectRegistry {
    private static final Map<ResourceLocation, ScannableObject> entityScannables = new HashMap<ResourceLocation, ScannableObject>();
    private static final Map<ResourceLocation, ScannableObject> blockScannables = new HashMap<ResourceLocation, ScannableObject>();

    public static void init() {
        ScannableObjectRegistry.registerEntity(ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"gravity_anomaly"), ResearchType.GRAVITY, Config.gravityResearchPoints);
        ScannableObjectRegistry.registerEntity(ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"warp_gate_anomaly"), ResearchType.SPACE, Config.warpResearchPoints);
        ScannableObjectRegistry.registerEntity(ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"energetic_rift"), ResearchType.ENERGY, Config.energeticResearchPoints);
        ScannableObjectRegistry.registerEntity(ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"echoing_shadow"), ResearchType.SHADOW, Config.shadowResearchPoints);
        ScannableObjectRegistry.registerEntity(ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"temporal_bloom"), ResearchType.TIME, Config.temporalResearchPoints);
        ScannableObjectRegistry.registerEntity(ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"thoughtwell"), ResearchType.COGNITION, Config.thoughtwellResearchPoints);
    }

    public static void registerEntity(ResourceLocation entityType, ResearchType researchType, int amount) {
        ScannableObject scannable = ScannableObject.forEntity(entityType, researchType, amount);
        entityScannables.put(entityType, scannable);
    }

    public static void registerBlock(ResourceLocation blockType, ResearchType researchType, int amount) {
        ScannableObject scannable = ScannableObject.forBlock(blockType, researchType, amount);
        blockScannables.put(blockType, scannable);
    }

    public static Optional<ScannableObject> getScannableForEntity(Entity entity) {
        ResourceLocation entityType = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        return Optional.ofNullable(entityScannables.get(entityType));
    }

    public static Optional<ScannableObject> getScannableForBlock(BlockState blockState) {
        ResourceLocation blockType = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_());
        return Optional.ofNullable(blockScannables.get(blockType));
    }

    public static boolean isEntityScannable(Entity entity) {
        return ScannableObjectRegistry.getScannableForEntity(entity).isPresent();
    }

    public static boolean isBlockScannable(BlockState blockState) {
        return ScannableObjectRegistry.getScannableForBlock(blockState).isPresent();
    }
}

