/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.research;

import com.hexvane.strangematter.research.ResearchType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ScannableObject {
    private final String id;
    private final ResearchType researchType;
    private final int researchAmount;
    private final boolean isEntity;
    private final ResourceLocation resourceLocation;

    public ScannableObject(String id, ResearchType researchType, int researchAmount, boolean isEntity, ResourceLocation resourceLocation) {
        this.id = id;
        this.researchType = researchType;
        this.researchAmount = researchAmount;
        this.isEntity = isEntity;
        this.resourceLocation = resourceLocation;
    }

    public String getId() {
        return this.id;
    }

    public ResearchType getResearchType() {
        return this.researchType;
    }

    public int getResearchAmount() {
        return this.researchAmount;
    }

    public boolean isEntity() {
        return this.isEntity;
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public String generateObjectId(Entity entity) {
        return this.id + "_" + entity.m_20148_().toString();
    }

    public String generateObjectId(BlockPos pos) {
        return this.id + "_" + pos.m_123341_() + "_" + pos.m_123342_() + "_" + pos.m_123343_();
    }

    public static ScannableObject forEntity(ResourceLocation entityType, ResearchType researchType, int amount) {
        return new ScannableObject(entityType.toString(), researchType, amount, true, entityType);
    }

    public static ScannableObject forBlock(ResourceLocation blockType, ResearchType researchType, int amount) {
        return new ScannableObject(blockType.toString(), researchType, amount, false, blockType);
    }
}

