/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.research;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public enum ResearchType {
    COGNITION("cognition", "strangematter:textures/ui/cognition_icon.png"),
    ENERGY("energy", "strangematter:textures/ui/energy_icon.png"),
    GRAVITY("gravity", "strangematter:textures/ui/gravity_icon.png"),
    SHADOW("shadow", "strangematter:textures/ui/shadow_icon.png"),
    SPACE("space", "strangematter:textures/ui/space_icon.png"),
    TIME("time", "strangematter:textures/ui/time_icon.png");

    private final String name;
    private final String iconPath;

    private ResearchType(String name, String iconPath) {
        this.name = name;
        this.iconPath = iconPath;
    }

    public String getName() {
        return this.name;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public ResourceLocation getIconResourceLocation() {
        return ResourceLocation.parse((String)this.iconPath);
    }

    public String getTranslationKey() {
        return "research.strangematter." + this.name;
    }

    public String getDisplayName() {
        return Component.m_237115_((String)this.getTranslationKey()).getString();
    }

    public static ResearchType fromName(String name) {
        for (ResearchType type : ResearchType.values()) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return null;
    }
}

