/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.research;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.research.ResearchNode;
import com.hexvane.strangematter.research.ResearchType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ResearchNodeRegistry {
    private static final Map<String, ResearchNode> nodes = new HashMap<String, ResearchNode>();
    private static final Map<String, List<ResearchNode>> nodesByCategory = new HashMap<String, List<ResearchNode>>();

    public static void register(ResearchNode node) {
        nodes.put(node.getId(), node);
        nodesByCategory.computeIfAbsent(node.getCategory(), k -> new ArrayList()).add(node);
    }

    private static Map<ResearchType, Integer> applyConfigCosts(String nodeId, Map<ResearchType, Integer> defaultCosts) {
        if (defaultCosts.isEmpty()) {
            return defaultCosts;
        }
        int overrideCost = ResearchNodeRegistry.getIndividualCostOverride(nodeId);
        HashMap<ResearchType, Integer> costs = new HashMap<ResearchType, Integer>(defaultCosts);
        if (overrideCost > 0) {
            int costPerType = Math.max(1, overrideCost / costs.size());
            for (ResearchType type : costs.keySet()) {
                costs.put(type, costPerType);
            }
        } else {
            double multiplier = Config.researchCostMultiplier;
            for (Map.Entry entry : costs.entrySet()) {
                int newCost = Math.max(1, (int)Math.round((double)((Integer)entry.getValue()).intValue() * multiplier));
                costs.put((ResearchType)((Object)entry.getKey()), newCost);
            }
        }
        return costs;
    }

    private static int getIndividualCostOverride(String nodeId) {
        return switch (nodeId) {
            case "anomaly_resonator" -> Config.anomalyResonatorCost;
            case "resonance_condenser" -> Config.resonanceCondenserCost;
            case "containment_basics" -> Config.containmentBasicsCost;
            case "echoform_imprinter" -> Config.echoformImprinterCost;
            case "reality_forge" -> Config.realityForgeCost;
            case "warp_gun" -> Config.warpGunCost;
            case "graviton_hammer" -> Config.gravitonHammerCost;
            case "stasis_projector" -> Config.stasisProjectorCost;
            case "rift_stabilizer" -> Config.riftStabilizerCost;
            case "gravity_anomalies" -> Config.gravityAnomaliesCost;
            case "temporal_anomalies" -> Config.temporalAnomaliesCost;
            case "spatial_anomalies" -> Config.spatialAnomaliesCost;
            case "energy_anomalies" -> Config.energyAnomaliesCost;
            case "shadow_anomalies" -> Config.shadowAnomaliesCost;
            case "cognitive_anomalies" -> Config.cognitiveAnomaliesCost;
            case "levitation_pad" -> Config.levitationPadCost;
            case "hoverboard" -> Config.hoverboardCost;
            default -> -1;
        };
    }

    public static ResearchNode getNode(String id) {
        return nodes.get(id);
    }

    public static List<ResearchNode> getNodesByCategory(String category) {
        return nodesByCategory.getOrDefault(category, Collections.emptyList());
    }

    public static List<String> getCategories() {
        return new ArrayList<String>(nodesByCategory.keySet());
    }

    public static Collection<ResearchNode> getAllNodes() {
        return nodes.values();
    }

    public static void initializeDefaultNodes() {
        Class<?> customRegistry2;
        nodes.clear();
        nodesByCategory.clear();
        try {
            customRegistry2 = Class.forName("com.hexvane.strangematter.kubejs.CustomResearchRegistry");
            customRegistry2.getMethod("reset", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception customRegistry2) {
            // empty catch block
        }
        ResearchNodeRegistry.register(new ResearchNode("research", "general", 0, 0, Map.of(), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.RESEARCH_NOTES.get()), true, List.of()));
        ResearchNodeRegistry.register(new ResearchNode("field_scanner", "general", -80, 0, Map.of(), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.FIELD_SCANNER.get()), false, List.of("research")));
        ResearchNodeRegistry.register(new ResearchNode("anomaly_shards", "general", 80, 0, Map.of(), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.GRAVITIC_SHARD.get()), true, List.of("research")));
        ResearchNodeRegistry.register(new ResearchNode("anomaly_types", "general", 0, -80, Map.of(), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)Items.f_42517_), true, List.of("research")));
        ResearchNodeRegistry.register(new ResearchNode("resonite", "general", -80, 80, Map.of(), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.RAW_RESONITE.get()), true, List.of("research")));
        ResearchNodeRegistry.register(new ResearchNode("tinfoil_hat", "general", -160, 80, ResearchNodeRegistry.applyConfigCosts("tinfoil_hat", Map.of(ResearchType.ENERGY, 10, ResearchType.COGNITION, 10)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.TINFOIL_HAT.get()), true, List.of("resonite")));
        ResearchNodeRegistry.register(new ResearchNode("resonant_energy", "general", 80, 80, Map.of(), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.RESONANT_BURNER_ITEM.get()), true, List.of("research")));
        ResearchNodeRegistry.register(new ResearchNode("anomaly_resonator", "general", -160, 0, ResearchNodeRegistry.applyConfigCosts("anomaly_resonator", Map.of(ResearchType.ENERGY, 10, ResearchType.SPACE, 10)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.ANOMALY_RESONATOR.get()), true, List.of("field_scanner")));
        ResearchNodeRegistry.register(new ResearchNode("resonance_condenser", "general", -160, 160, ResearchNodeRegistry.applyConfigCosts("resonance_condenser", Map.of(ResearchType.ENERGY, 25, ResearchType.SPACE, 15)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.RESONANCE_CONDENSER_ITEM.get()), true, List.of("reality_forge")));
        ResearchNodeRegistry.register(new ResearchNode("containment_basics", "general", -80, 400, ResearchNodeRegistry.applyConfigCosts("containment_basics", Map.of(ResearchType.ENERGY, 20, ResearchType.SHADOW, 15)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.ECHO_VACUUM.get()), true, List.of("reality_forge")));
        ResearchNodeRegistry.register(new ResearchNode("echoform_imprinter", "general", 80, 400, ResearchNodeRegistry.applyConfigCosts("echoform_imprinter", Map.of(ResearchType.SHADOW, 25, ResearchType.COGNITION, 20)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.ECHOFORM_IMPRINTER.get()), true, List.of("containment_basics")));
        ResearchNodeRegistry.register(new ResearchNode("reality_forge", "general", -80, 240, ResearchNodeRegistry.applyConfigCosts("reality_forge", Map.of(ResearchType.ENERGY, 5, ResearchType.SPACE, 5, ResearchType.TIME, 5)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.REALITY_FORGE_ITEM.get()), true, List.of("resonite")));
        ResearchNodeRegistry.register(new ResearchNode("warp_gun", "general", 0, 320, ResearchNodeRegistry.applyConfigCosts("warp_gun", Map.of(ResearchType.SPACE, 15, ResearchType.ENERGY, 10)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.WARP_GUN.get()), true, List.of("containment_basics")));
        ResearchNodeRegistry.register(new ResearchNode("chrono_blister", "general", 80, 320, ResearchNodeRegistry.applyConfigCosts("chrono_blister", Map.of(ResearchType.TIME, 15, ResearchType.ENERGY, 10)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.CHRONO_BLISTER.get()), true, List.of("temporal_anomalies")));
        ResearchNodeRegistry.register(new ResearchNode("graviton_hammer", "general", -80, 480, ResearchNodeRegistry.applyConfigCosts("graviton_hammer", Map.of(ResearchType.GRAVITY, 20, ResearchType.ENERGY, 5)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.GRAVITON_HAMMER.get()), true, List.of("containment_basics")));
        ResearchNodeRegistry.register(new ResearchNode("stasis_projector", "general", 80, 240, ResearchNodeRegistry.applyConfigCosts("stasis_projector", Map.of(ResearchType.GRAVITY, 5, ResearchType.TIME, 5)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.STASIS_PROJECTOR_ITEM.get()), true, List.of("reality_forge")));
        ResearchNodeRegistry.register(new ResearchNode("rift_stabilizer", "general", 0, 160, ResearchNodeRegistry.applyConfigCosts("rift_stabilizer", Map.of(ResearchType.ENERGY, 20, ResearchType.SPACE, 10)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.RIFT_STABILIZER_ITEM.get()), true, List.of("reality_forge")));
        ResearchNodeRegistry.register(new ResearchNode("levitation_pad", "general", -240, 240, ResearchNodeRegistry.applyConfigCosts("levitation_pad", Map.of(ResearchType.GRAVITY, 15, ResearchType.ENERGY, 10)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.LEVITATION_PAD_ITEM.get()), true, List.of("reality_forge")));
        ResearchNodeRegistry.register(new ResearchNode("hoverboard", "general", -240, 400, ResearchNodeRegistry.applyConfigCosts("hoverboard", Map.of(ResearchType.GRAVITY, 10, ResearchType.ENERGY, 15)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.HOVERBOARD.get()), true, List.of("containment_basics")));
        ResearchNodeRegistry.register(new ResearchNode("gravity_anomalies", "general", -80, -160, ResearchNodeRegistry.applyConfigCosts("gravity_anomalies", Map.of(ResearchType.GRAVITY, 5)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.GRAVITIC_SHARD.get()), true, List.of("anomaly_types")));
        ResearchNodeRegistry.register(new ResearchNode("temporal_anomalies", "general", 0, -160, ResearchNodeRegistry.applyConfigCosts("temporal_anomalies", Map.of(ResearchType.TIME, 5)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.CHRONO_SHARD.get()), true, List.of("anomaly_types")));
        ResearchNodeRegistry.register(new ResearchNode("spatial_anomalies", "general", 80, -160, ResearchNodeRegistry.applyConfigCosts("spatial_anomalies", Map.of(ResearchType.SPACE, 5)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.SPATIAL_SHARD.get()), true, List.of("anomaly_types")));
        ResearchNodeRegistry.register(new ResearchNode("energy_anomalies", "general", -80, -240, ResearchNodeRegistry.applyConfigCosts("energy_anomalies", Map.of(ResearchType.ENERGY, 5)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.ENERGETIC_SHARD.get()), true, List.of("anomaly_types")));
        ResearchNodeRegistry.register(new ResearchNode("shadow_anomalies", "general", 0, -240, ResearchNodeRegistry.applyConfigCosts("shadow_anomalies", Map.of(ResearchType.SHADOW, 5)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.SHADE_SHARD.get()), true, List.of("anomaly_types")));
        ResearchNodeRegistry.register(new ResearchNode("cognitive_anomalies", "general", 80, -240, ResearchNodeRegistry.applyConfigCosts("cognitive_anomalies", Map.of(ResearchType.COGNITION, 5)), ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png"), new ItemStack((ItemLike)StrangeMatterMod.INSIGHT_SHARD.get()), true, List.of("anomaly_types")));
        try {
            customRegistry2 = Class.forName("com.hexvane.strangematter.kubejs.CustomResearchRegistry");
            customRegistry2.getMethod("initializeCustomResearch", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResearchNodeRegistry.loadSavedPositions();
    }

    private static void loadSavedPositions() {
        if (FMLEnvironment.dist != Dist.CLIENT) {
            return;
        }
        try {
            Class<?> positionManager = Class.forName("com.hexvane.strangematter.client.research.ResearchNodePositionManager");
            Object instance = positionManager.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            positionManager.getMethod("loadPositions", new Class[0]).invoke(instance, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

