/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.research;

import com.hexvane.strangematter.research.ResearchType;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ResearchNode {
    private final String id;
    private final String category;
    private final int x;
    private final int y;
    private final Map<ResearchType, Integer> researchCosts;
    private final ResourceLocation iconTexture;
    private final ItemStack iconItem;
    private final boolean requiresMultipleAspects;
    private final List<String> prerequisites;

    public ResearchNode(String id, String category, int x, int y, Map<ResearchType, Integer> researchCosts, ResourceLocation iconTexture, ItemStack iconItem, boolean requiresMultipleAspects, List<String> prerequisites) {
        this.id = id;
        this.category = category;
        this.x = x;
        this.y = y;
        this.researchCosts = researchCosts;
        this.iconTexture = iconTexture;
        this.iconItem = iconItem;
        this.requiresMultipleAspects = requiresMultipleAspects;
        this.prerequisites = prerequisites;
    }

    public String getId() {
        return this.id;
    }

    public Component getDisplayName() {
        return Component.m_237115_((String)("research.strangematter." + this.id + ".name"));
    }

    public Component getDisplayDescription() {
        return Component.m_237115_((String)("research.strangematter." + this.id + ".description"));
    }

    public String getCategory() {
        return this.category;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Map<ResearchType, Integer> getResearchCosts() {
        return this.researchCosts;
    }

    public int getTotalCost() {
        return this.researchCosts.values().stream().mapToInt(Integer::intValue).sum();
    }

    public boolean requiresMultipleAspects() {
        return this.requiresMultipleAspects;
    }

    public ResourceLocation getIconTexture() {
        return this.iconTexture;
    }

    public ItemStack getIconItem() {
        return this.iconItem;
    }

    public boolean hasIconTexture() {
        return this.iconTexture != null;
    }

    public boolean hasIconItem() {
        return this.iconItem != null && !this.iconItem.m_41619_();
    }

    public boolean canAfford(Map<ResearchType, Integer> playerPoints) {
        for (Map.Entry<ResearchType, Integer> cost : this.researchCosts.entrySet()) {
            int playerPointsForType = playerPoints.getOrDefault((Object)cost.getKey(), 0);
            if (playerPointsForType >= cost.getValue()) continue;
            return false;
        }
        return true;
    }

    public List<String> getPrerequisites() {
        return this.prerequisites;
    }

    public boolean hasPrerequisites() {
        return this.prerequisites != null && !this.prerequisites.isEmpty();
    }
}

