/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.research;

import com.hexvane.strangematter.research.ResearchData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class ResearchDataManager
extends SavedData {
    private static final String DATA_NAME = "strangematter_research_data";
    private final Map<UUID, ResearchData> playerResearchData = new HashMap<UUID, ResearchData>();

    public static ResearchDataManager get(ServerLevel level) {
        ServerLevel storageLevel = level;
        if (level.m_7654_() != null) {
            storageLevel = level.m_7654_().m_129783_();
        }
        return (ResearchDataManager)storageLevel.m_8895_().m_164861_(ResearchDataManager::load, ResearchDataManager::new, DATA_NAME);
    }

    public static ResearchData get(Player player) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ResearchDataManager manager = ResearchDataManager.get(serverLevel);
            return manager.getPlayerResearchData(player.m_20148_());
        }
        return new ResearchData();
    }

    public ResearchData getPlayerResearchData(UUID playerId) {
        return this.playerResearchData.computeIfAbsent(playerId, k -> {
            ResearchData data = new ResearchData();
            data.setManager(this, playerId);
            return data;
        });
    }

    public void markDirty() {
        this.m_77762_();
    }

    public void setPlayerResearchData(UUID playerId, ResearchData data) {
        this.playerResearchData.put(playerId, data);
        this.m_77762_();
    }

    public CompoundTag m_7176_(@Nonnull CompoundTag tag) {
        CompoundTag playersTag = new CompoundTag();
        for (Map.Entry<UUID, ResearchData> entry : this.playerResearchData.entrySet()) {
            playersTag.m_128365_(entry.getKey().toString(), (Tag)entry.getValue().serializeNBT());
        }
        tag.m_128365_("players", (Tag)playersTag);
        return tag;
    }

    public static ResearchDataManager load(CompoundTag tag) {
        ResearchDataManager manager = new ResearchDataManager();
        if (tag.m_128441_("players")) {
            CompoundTag playersTag = tag.m_128469_("players");
            for (String key : playersTag.m_128431_()) {
                try {
                    UUID playerId = UUID.fromString(key);
                    ResearchData data = new ResearchData();
                    data.deserializeNBT(playersTag.m_128469_(key));
                    data.setManager(manager, playerId);
                    manager.playerResearchData.put(playerId, data);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return manager;
    }
}

