/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.research;

import com.hexvane.strangematter.research.ResearchDataManager;
import com.hexvane.strangematter.research.ResearchDataServerHandler;
import com.hexvane.strangematter.research.ResearchType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ResearchData {
    private final Map<ResearchType, Integer> researchPoints = new HashMap<ResearchType, Integer>();
    private final Set<String> scannedObjects = new HashSet<String>();
    private final Set<String> unlockedResearch = new HashSet<String>();
    private ResearchDataManager manager;
    private UUID playerId;

    public ResearchData() {
        for (ResearchType type : ResearchType.values()) {
            this.researchPoints.put(type, 0);
        }
        this.initializeDefaultUnlockedResearch();
    }

    private void initializeDefaultUnlockedResearch() {
        this.unlockResearch("research");
        this.unlockResearch("field_scanner");
        this.unlockResearch("anomaly_shards");
        this.unlockResearch("anomaly_types");
        this.unlockResearch("resonite");
        this.unlockResearch("resonant_energy");
    }

    public void setManager(ResearchDataManager manager, UUID playerId) {
        this.manager = manager;
        this.playerId = playerId;
    }

    public int getResearchPoints(ResearchType type) {
        return this.researchPoints.getOrDefault((Object)type, 0);
    }

    public void addResearchPoints(ResearchType type, int amount) {
        int current = this.researchPoints.getOrDefault((Object)type, 0);
        this.researchPoints.put(type, current + amount);
        this.markDirty();
    }

    public void spendResearchPoints(ResearchType type, int amount) {
        int current = this.researchPoints.getOrDefault((Object)type, 0);
        this.researchPoints.put(type, Math.max(0, current - amount));
        this.markDirty();
    }

    public boolean hasScanned(String objectId) {
        return this.scannedObjects.contains(objectId);
    }

    public void markAsScanned(String objectId) {
        this.scannedObjects.add(objectId);
        this.markDirty();
    }

    public Set<String> getScannedObjects() {
        return new HashSet<String>(this.scannedObjects);
    }

    public void setScannedObjects(Set<String> scanned) {
        this.scannedObjects.clear();
        this.scannedObjects.addAll(scanned);
        this.markDirty();
    }

    public boolean hasUnlockedResearch(String researchId) {
        return this.unlockedResearch.contains(researchId);
    }

    public void unlockResearch(String researchId) {
        this.unlockedResearch.add(researchId);
        this.markDirty();
    }

    public Set<String> getUnlockedResearch() {
        return new HashSet<String>(this.unlockedResearch);
    }

    public void setUnlockedResearch(Set<String> unlocked) {
        this.unlockedResearch.clear();
        this.unlockedResearch.addAll(unlocked);
        this.markDirty();
    }

    private void markDirty() {
        if (this.manager != null) {
            this.manager.markDirty();
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        CompoundTag researchTag = new CompoundTag();
        for (Map.Entry<ResearchType, Integer> entry : this.researchPoints.entrySet()) {
            researchTag.m_128405_(entry.getKey().getName(), entry.getValue().intValue());
        }
        tag.m_128365_("research_points", (Tag)researchTag);
        ListTag scannedTag = new ListTag();
        for (String objectId : this.scannedObjects) {
            CompoundTag objectTag = new CompoundTag();
            objectTag.m_128359_("id", objectId);
            scannedTag.add((Object)objectTag);
        }
        tag.m_128365_("scanned_objects", (Tag)scannedTag);
        ListTag listTag = new ListTag();
        for (String researchId : this.unlockedResearch) {
            CompoundTag unlockedResearchTag = new CompoundTag();
            unlockedResearchTag.m_128359_("id", researchId);
            listTag.add((Object)unlockedResearchTag);
        }
        tag.m_128365_("unlocked_research", (Tag)listTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.researchPoints.clear();
        this.scannedObjects.clear();
        this.unlockedResearch.clear();
        if (tag.m_128441_("research_points")) {
            CompoundTag researchTag = tag.m_128469_("research_points");
            for (ResearchType type : ResearchType.values()) {
                if (researchTag.m_128441_(type.getName())) {
                    this.researchPoints.put(type, researchTag.m_128451_(type.getName()));
                    continue;
                }
                this.researchPoints.put(type, 0);
            }
        }
        if (tag.m_128441_("scanned_objects")) {
            ListTag scannedTag = tag.m_128437_("scanned_objects", 10);
            for (Tag t : scannedTag) {
                if (!(t instanceof CompoundTag)) continue;
                CompoundTag objectTag = (CompoundTag)t;
                this.scannedObjects.add(objectTag.m_128461_("id"));
            }
        }
        if (tag.m_128441_("unlocked_research")) {
            ListTag unlockedTag = tag.m_128437_("unlocked_research", 10);
            for (Tag t : unlockedTag) {
                if (!(t instanceof CompoundTag)) continue;
                CompoundTag researchTag = (CompoundTag)t;
                this.unlockedResearch.add(researchTag.m_128461_("id"));
            }
        }
        this.initializeDefaultUnlockedResearch();
    }

    public void syncToClient(ServerPlayer player) {
        ResearchDataServerHandler.syncResearchDataToClient(player, this);
    }

    public static ResearchData get(Player player) {
        if (player.m_9236_().f_46443_) {
            return new ResearchData();
        }
        return ResearchDataManager.get(player);
    }
}

