/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.research;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public abstract class AnomalousEvent {
    protected final String eventId;
    protected final int severity;

    public AnomalousEvent(String eventId, int severity) {
        this.eventId = eventId;
        this.severity = Math.max(1, Math.min(10, severity));
    }

    public abstract void trigger(ServerLevel var1, BlockPos var2, ServerPlayer var3);

    public abstract String getDisplayName();

    public abstract String getDescription();

    public boolean canOccur(Level level, BlockPos machinePos, ServerPlayer player) {
        return true;
    }

    public String getEventId() {
        return this.eventId;
    }

    public int getSeverity() {
        return this.severity;
    }

    public static AnomalousEvent getRandomEvent(Level level, BlockPos machinePos, ServerPlayer player, int maxSeverity) {
        return new TemporalDisruptionEvent();
    }

    public static class TemporalDisruptionEvent
    extends AnomalousEvent {
        public TemporalDisruptionEvent() {
            super("temporal_disruption", 3);
        }

        @Override
        public void trigger(ServerLevel level, BlockPos machinePos, ServerPlayer player) {
            player.m_213846_((Component)Component.m_237115_((String)"research.strangematter.event.temporal_disruption.message"));
        }

        @Override
        public String getDisplayName() {
            return "Temporal Disruption";
        }

        @Override
        public String getDescription() {
            return "Time itself becomes unstable around the research machine.";
        }
    }

    public static class QuantumEntanglementEvent
    extends AnomalousEvent {
        public QuantumEntanglementEvent() {
            super("quantum_entanglement", 5);
        }

        @Override
        public void trigger(ServerLevel level, BlockPos machinePos, ServerPlayer player) {
            player.m_213846_((Component)Component.m_237115_((String)"research.strangematter.event.quantum_entanglement.message"));
        }

        @Override
        public String getDisplayName() {
            return "Quantum Entanglement";
        }

        @Override
        public String getDescription() {
            return "Quantum particles become entangled, causing unpredictable effects.";
        }
    }

    public static class RealityFractureEvent
    extends AnomalousEvent {
        public RealityFractureEvent() {
            super("reality_fracture", 7);
        }

        @Override
        public void trigger(ServerLevel level, BlockPos machinePos, ServerPlayer player) {
            player.m_213846_((Component)Component.m_237115_((String)"research.strangematter.event.reality_fracture.message"));
        }

        @Override
        public String getDisplayName() {
            return "Reality Fracture";
        }

        @Override
        public String getDescription() {
            return "The fabric of reality tears near the research machine.";
        }
    }
}

