/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.registry;

import com.hexvane.strangematter.entity.WarpGateAnomalyEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WarpGateRegistry {
    private static final Map<UUID, WarpGateEntry> warpGates = new ConcurrentHashMap<UUID, WarpGateEntry>();

    public static void registerWarpGate(WarpGateAnomalyEntity warpGate) {
        UUID uuid = warpGate.m_20148_();
        Level level = warpGate.m_9236_();
        Vec3 position = warpGate.m_20182_();
        WarpGateEntry entry = new WarpGateEntry(uuid, level, position, false);
        warpGates.put(uuid, entry);
        System.out.println("WarpGateRegistry: Registered warp gate " + uuid + " at " + position + " in level " + level.m_46472_().m_135782_());
    }

    public static void unregisterWarpGate(UUID uuid) {
        WarpGateEntry removed = warpGates.remove(uuid);
        if (removed != null) {
            System.out.println("WarpGateRegistry: Unregistered warp gate " + uuid + " at " + removed.position);
        }
    }

    public static WarpGateEntry findUnpairedWarpGate(Level level, Vec3 fromPosition, double minDistance) {
        ArrayList<WarpGateEntry> candidates = new ArrayList<WarpGateEntry>();
        for (WarpGateEntry entry : warpGates.values()) {
            double distance;
            if (!entry.level.equals(level) || entry.isPaired || (distance = entry.position.m_82554_(fromPosition)) < minDistance || entry.position.equals((Object)fromPosition)) continue;
            candidates.add(entry);
        }
        if (candidates.isEmpty()) {
            System.out.println("WarpGateRegistry: No unpaired warp gates found in level " + level.m_46472_().m_135782_());
            return null;
        }
        candidates.sort((a, b) -> Double.compare(a.position.m_82554_(fromPosition), b.position.m_82554_(fromPosition)));
        int maxCandidates = Math.min(3, candidates.size());
        WarpGateEntry selected = (WarpGateEntry)candidates.get(new Random().nextInt(maxCandidates));
        System.out.println("WarpGateRegistry: Found " + candidates.size() + " unpaired candidates, selected gate at " + selected.position + " (distance: " + selected.position.m_82554_(fromPosition) + ")");
        return selected;
    }

    public static void markWarpGateAsPaired(UUID uuid) {
        WarpGateEntry entry = warpGates.get(uuid);
        if (entry != null) {
            entry.markAsPaired();
            System.out.println("WarpGateRegistry: Marked warp gate " + uuid + " as paired");
        }
    }

    public static List<WarpGateEntry> getWarpGatesInLevel(Level level) {
        return warpGates.values().stream().filter(entry -> entry.level.equals(level)).toList();
    }

    public static String getDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("WarpGateRegistry Debug Info:\n");
        sb.append("Total registered gates: ").append(warpGates.size()).append("\n");
        for (WarpGateEntry entry : warpGates.values()) {
            sb.append("- UUID: ").append(entry.uuid).append(", Level: ").append(entry.level.m_46472_().m_135782_()).append(", Position: ").append(entry.position).append(", Paired: ").append(entry.isPaired).append(", Age: ").append(System.currentTimeMillis() - entry.spawnTime).append("ms\n");
        }
        return sb.toString();
    }

    public static class WarpGateEntry {
        public final UUID uuid;
        public final Level level;
        public final Vec3 position;
        public final boolean isPaired;
        public final long spawnTime;

        public WarpGateEntry(UUID uuid, Level level, Vec3 position, boolean isPaired) {
            this.uuid = uuid;
            this.level = level;
            this.position = position;
            this.isPaired = isPaired;
            this.spawnTime = System.currentTimeMillis();
        }

        public void markAsPaired() {
            warpGates.put(this.uuid, new WarpGateEntry(this.uuid, this.level, this.position, true));
        }
    }
}

