/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.recipe;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.block.RealityForgeBlockEntity;
import com.hexvane.strangematter.recipe.RealityForgeRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class RealityForgeRecipeRegistry {
    private static final List<RealityForgeRecipe> recipes = new ArrayList<RealityForgeRecipe>();

    public static void register(RealityForgeRecipe recipe) {
        recipes.add(recipe);
    }

    public static RealityForgeRecipe findMatchingRecipe(RealityForgeBlockEntity blockEntity) {
        Level level = blockEntity.m_58904_();
        if (level == null) {
            System.out.println("DEBUG: findMatchingRecipe - level is null");
            return null;
        }
        RecipeManager recipeManager = level.m_7465_();
        RecipeType recipeType = (RecipeType)StrangeMatterMod.REALITY_FORGE_RECIPE_TYPE.get();
        List allRecipes = recipeManager.m_44013_(recipeType);
        for (RealityForgeRecipe recipe : allRecipes) {
            if (!recipe.m_5818_(blockEntity, level)) continue;
            return recipe;
        }
        return null;
    }

    public static List<RealityForgeRecipe> getAllRecipes() {
        return new ArrayList<RealityForgeRecipe>(recipes);
    }

    public static RealityForgeRecipe findRecipeByResult(ResourceLocation resultItemId, Level level) {
        if (level == null) {
            return null;
        }
        RecipeManager recipeManager = level.m_7465_();
        RecipeType recipeType = (RecipeType)StrangeMatterMod.REALITY_FORGE_RECIPE_TYPE.get();
        List allRecipes = recipeManager.m_44013_(recipeType);
        for (RealityForgeRecipe recipe : allRecipes) {
            ResourceLocation recipeResultId = ForgeRegistries.ITEMS.getKey((Object)recipe.m_8043_(null).m_41720_());
            if (recipeResultId == null || !recipeResultId.equals((Object)resultItemId)) continue;
            return recipe;
        }
        return null;
    }

    public static void clear() {
        recipes.clear();
    }

    public static void initializeDefaultRecipes() {
        RealityForgeRecipeRegistry.clear();
        RealityForgeRecipeRegistry.registerWarpGunRecipe();
    }

    private static void registerWarpGunRecipe() {
    }
}

