/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.block.RealityForgeBlockEntity;
import com.hexvane.strangematter.research.ResearchData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class RealityForgeRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ItemStack result;
    private final NonNullList<Ingredient> ingredients;
    private final Map<String, Integer> shardRequirements;
    private final String requiredResearch;

    public RealityForgeRecipe(ResourceLocation id, ItemStack result, NonNullList<Ingredient> ingredients, Map<String, Integer> shardRequirements, String requiredResearch) {
        this.id = id;
        this.result = result;
        this.ingredients = ingredients;
        this.shardRequirements = shardRequirements;
        this.requiredResearch = requiredResearch;
    }

    public boolean m_5818_(Container container, Level level) {
        for (int i = 0; i < 9; ++i) {
            if (((Ingredient)this.ingredients.get(i)).test(container.m_8020_(i))) continue;
            return false;
        }
        if (container instanceof RealityForgeBlockEntity) {
            RealityForgeBlockEntity realityForge = (RealityForgeBlockEntity)container;
            Map<String, Integer> storedShards = realityForge.getStoredShards();
            for (Map.Entry<String, Integer> requirement : this.shardRequirements.entrySet()) {
                String shardType = requirement.getKey();
                int required = requirement.getValue();
                int available = storedShards.getOrDefault(shardType, 0);
                if (available >= required) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canCraftByPlayer(Player player) {
        if (this.requiredResearch == null || this.requiredResearch.isEmpty()) {
            return true;
        }
        ResearchData researchData = ResearchData.get(player);
        return researchData.hasUnlockedResearch(this.requiredResearch);
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)StrangeMatterMod.REALITY_FORGE_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)StrangeMatterMod.REALITY_FORGE_RECIPE_TYPE.get();
    }

    public Map<String, Integer> getShardRequirements() {
        return new HashMap<String, Integer>(this.shardRequirements);
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public String getRequiredResearch() {
        return this.requiredResearch;
    }

    public static class Serializer
    implements RecipeSerializer<RealityForgeRecipe> {
        public RealityForgeRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            NonNullList ingredients = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
            JsonArray patternArray = GsonHelper.m_13933_((JsonObject)json, (String)"pattern");
            String[] pattern = new String[patternArray.size()];
            for (int i = 0; i < patternArray.size(); ++i) {
                pattern[i] = patternArray.get(i).getAsString();
            }
            if (pattern.length != 3) {
                throw new IllegalArgumentException("Pattern must have exactly 3 rows");
            }
            JsonObject key = GsonHelper.m_13930_((JsonObject)json, (String)"key");
            for (int i = 0; i < 3; ++i) {
                String row = pattern[i];
                if (row.length() != 3) {
                    throw new IllegalArgumentException("Each pattern row must have exactly 3 characters");
                }
                for (int j = 0; j < 3; ++j) {
                    char c = row.charAt(j);
                    if (c == ' ') continue;
                    ingredients.set(i * 3 + j, (Object)Ingredient.m_43917_((JsonElement)key.getAsJsonObject(String.valueOf(c))));
                }
            }
            HashMap<String, Integer> shardRequirements = new HashMap<String, Integer>();
            if (json.has("shards")) {
                JsonObject shards = GsonHelper.m_13930_((JsonObject)json, (String)"shards");
                for (String key2 : shards.keySet()) {
                    shardRequirements.put(key2, GsonHelper.m_13927_((JsonObject)shards, (String)key2));
                }
            }
            String requiredResearch = null;
            if (json.has("required_research")) {
                requiredResearch = GsonHelper.m_13906_((JsonObject)json, (String)"required_research");
            }
            return new RealityForgeRecipe(recipeId, result, (NonNullList<Ingredient>)ingredients, shardRequirements, requiredResearch);
        }

        public RealityForgeRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ItemStack result = buffer.m_130267_();
            NonNullList ingredients = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
            for (int i = 0; i < 9; ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            HashMap<String, Integer> shardRequirements = new HashMap<String, Integer>();
            int shardCount = buffer.readInt();
            for (int i = 0; i < shardCount; ++i) {
                String shardType = buffer.m_130277_();
                int amount = buffer.readInt();
                shardRequirements.put(shardType, amount);
            }
            String requiredResearch = null;
            if (buffer.readBoolean()) {
                requiredResearch = buffer.m_130277_();
            }
            return new RealityForgeRecipe(recipeId, result, (NonNullList<Ingredient>)ingredients, shardRequirements, requiredResearch);
        }

        public void toNetwork(FriendlyByteBuf buffer, RealityForgeRecipe recipe) {
            buffer.m_130055_(recipe.result);
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            buffer.writeInt(recipe.shardRequirements.size());
            for (Map.Entry<String, Integer> entry : recipe.shardRequirements.entrySet()) {
                buffer.m_130070_(entry.getKey());
                buffer.writeInt(entry.getValue().intValue());
            }
            if (recipe.requiredResearch != null) {
                buffer.writeBoolean(true);
                buffer.m_130070_(recipe.requiredResearch);
            } else {
                buffer.writeBoolean(false);
            }
        }
    }
}

