/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class EnergyAbsorptionParticle
extends TextureSheetParticle {
    private final double targetX;
    private final double targetY;
    private final double targetZ;
    private final double pullStrength;

    protected EnergyAbsorptionParticle(ClientLevel level, double x, double y, double z, double targetX, double targetY, double targetZ, double pullStrength) {
        super(level, x, y, z);
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetZ = targetZ;
        this.pullStrength = pullStrength;
        this.f_107225_ = 60 + level.f_46441_.m_188503_(40);
        this.m_6569_(0.3f + level.f_46441_.m_188501_() * 0.4f);
        this.f_107230_ = 0.8f;
        this.f_107227_ = 0.0f;
        this.f_107228_ = 0.8f + level.f_46441_.m_188501_() * 0.2f;
        this.f_107229_ = 1.0f;
        this.f_107215_ = (level.f_46441_.m_188500_() - 0.5) * 0.1;
        this.f_107216_ = (level.f_46441_.m_188500_() - 0.5) * 0.1;
        this.f_107217_ = (level.f_46441_.m_188500_() - 0.5) * 0.1;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        double dx = this.targetX - this.f_107212_;
        double dy = this.targetY - this.f_107213_;
        double dz = this.targetZ - this.f_107214_;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (distance > 0.1) {
            double pullX = dx / distance * this.pullStrength;
            double pullY = dy / distance * this.pullStrength;
            double pullZ = dz / distance * this.pullStrength;
            double distanceFactor = Math.min(1.0, distance / 5.0);
            this.f_107215_ += pullX * distanceFactor * 0.1;
            this.f_107216_ += pullY * distanceFactor * 0.1;
            this.f_107217_ += pullZ * distanceFactor * 0.1;
            this.f_107215_ *= 0.95;
            this.f_107216_ *= 0.95;
            this.f_107217_ *= 0.95;
        }
        this.f_107212_ += this.f_107215_;
        this.f_107213_ += this.f_107216_;
        this.f_107214_ += this.f_107217_;
        double fadeDistance = Math.min(distance, 2.0);
        this.f_107230_ = (float)((double)0.8f * (fadeDistance / 2.0));
        this.f_107216_ += Math.sin((double)this.f_107224_ * 0.1) * 0.001;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            EnergyAbsorptionParticle particle = new EnergyAbsorptionParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, 0.05);
            particle.m_108335_(this.spriteSet);
            return particle;
        }
    }
}

