/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.network;

import com.hexvane.strangematter.block.ResearchMachineBlockEntity;
import com.hexvane.strangematter.research.ResearchType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class UpdateMinigameStatesPacket {
    private final BlockPos pos;
    private final Map<ResearchType, Boolean> minigameStates;

    public UpdateMinigameStatesPacket(BlockPos pos, Map<ResearchType, Boolean> minigameStates) {
        this.pos = pos;
        this.minigameStates = minigameStates;
    }

    public static void encode(UpdateMinigameStatesPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.writeInt(packet.minigameStates.size());
        for (Map.Entry<ResearchType, Boolean> entry : packet.minigameStates.entrySet()) {
            buffer.m_130068_((Enum)entry.getKey());
            buffer.writeBoolean(entry.getValue().booleanValue());
        }
    }

    public static UpdateMinigameStatesPacket new_(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        int size = buffer.readInt();
        HashMap<ResearchType, Boolean> minigameStates = new HashMap<ResearchType, Boolean>();
        for (int i = 0; i < size; ++i) {
            ResearchType type = (ResearchType)buffer.m_130066_(ResearchType.class);
            boolean isStable = buffer.readBoolean();
            minigameStates.put(type, isStable);
        }
        return new UpdateMinigameStatesPacket(pos, minigameStates);
    }

    public static void handle(UpdateMinigameStatesPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player;
            Level level;
            BlockEntity blockEntity;
            if (context.getSender() != null && (blockEntity = (level = (player = context.getSender()).m_9236_()).m_7702_(packet.pos)) instanceof ResearchMachineBlockEntity) {
                ResearchMachineBlockEntity researchMachineBlockEntity = (ResearchMachineBlockEntity)blockEntity;
            }
        });
        context.setPacketHandled(true);
    }
}

