/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.network;

import com.hexvane.strangematter.client.network.ClientPacketHandlers;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class TimeDilationSyncPacket {
    private final double slowdownFactor;

    public TimeDilationSyncPacket(double slowdownFactor) {
        this.slowdownFactor = slowdownFactor;
    }

    public TimeDilationSyncPacket(FriendlyByteBuf buffer) {
        this.slowdownFactor = buffer.readDouble();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.slowdownFactor);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isClient()) {
                double factor = this.slowdownFactor;
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandlers.handleTimeDilationSync(factor));
            }
        });
        context.setPacketHandled(true);
    }

    public double getSlowdownFactor() {
        return this.slowdownFactor;
    }
}

