/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.network;

import com.hexvane.strangematter.item.ResearchNoteItem;
import com.hexvane.strangematter.research.ResearchData;
import com.hexvane.strangematter.research.ResearchNodeRegistry;
import com.hexvane.strangematter.research.ResearchType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SpendResearchPointsPacket {
    private final Map<ResearchType, Integer> costs;
    private final String researchId;

    public SpendResearchPointsPacket(Map<ResearchType, Integer> costs, String researchId) {
        this.costs = costs;
        this.researchId = researchId;
    }

    public static void encode(SpendResearchPointsPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.costs.size());
        for (Map.Entry<ResearchType, Integer> entry : packet.costs.entrySet()) {
            buffer.m_130068_((Enum)entry.getKey());
            buffer.writeInt(entry.getValue().intValue());
        }
        buffer.m_130070_(packet.researchId);
    }

    public static SpendResearchPointsPacket new_(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<ResearchType, Integer> costs = new HashMap<ResearchType, Integer>();
        for (int i = 0; i < size; ++i) {
            ResearchType type = (ResearchType)buffer.m_130066_(ResearchType.class);
            int amount = buffer.readInt();
            costs.put(type, amount);
        }
        String researchId = buffer.m_130277_();
        return new SpendResearchPointsPacket(costs, researchId);
    }

    public static void handle(SpendResearchPointsPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getSender() != null) {
                ServerPlayer player = context.getSender();
                ResearchData researchData = ResearchData.get((Player)player);
                boolean canAfford = true;
                for (Map.Entry<ResearchType, Integer> entry : packet.costs.entrySet()) {
                    if (researchData.getResearchPoints(entry.getKey()) >= entry.getValue()) continue;
                    canAfford = false;
                    break;
                }
                if (canAfford) {
                    for (Map.Entry<ResearchType, Integer> entry : packet.costs.entrySet()) {
                        researchData.spendResearchPoints(entry.getKey(), entry.getValue());
                    }
                    ItemStack researchNote = ResearchNoteItem.createResearchNote(packet.costs, packet.researchId);
                    if (player.m_150109_().m_36054_(researchNote)) {
                        researchData.syncToClient(player);
                        player.m_213846_((Component)Component.m_237110_((String)"research.strangematter.note_received", (Object[])new Object[]{ResearchNodeRegistry.getNode(packet.researchId).getDisplayName()}));
                    } else {
                        for (Map.Entry<ResearchType, Integer> entry : packet.costs.entrySet()) {
                            researchData.addResearchPoints(entry.getKey(), entry.getValue());
                        }
                        researchData.syncToClient(player);
                        player.m_213846_((Component)Component.m_237115_((String)"research.strangematter.inventory_full"));
                    }
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"research.strangematter.cannot_afford"));
                }
            }
        });
        context.setPacketHandled(true);
    }
}

