/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.network;

import com.hexvane.strangematter.client.network.ClientPacketHandlers;
import com.hexvane.strangematter.research.ResearchData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ResearchSyncPacket {
    private final ResearchData researchData;

    public ResearchSyncPacket(ResearchData researchData) {
        this.researchData = researchData;
    }

    public ResearchSyncPacket(FriendlyByteBuf buf) {
        this.researchData = new ResearchData();
        this.researchData.deserializeNBT(buf.m_130260_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130079_(this.researchData.serializeNBT());
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isClient()) {
                ResearchData finalData = this.researchData;
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandlers.handleResearchSync(finalData));
            }
        });
        context.setPacketHandled(true);
    }
}

