/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.network;

import com.hexvane.strangematter.block.ResearchMachineBlockEntity;
import com.hexvane.strangematter.client.network.ClientPacketHandlers;
import com.hexvane.strangematter.research.ResearchType;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ResearchMachineSyncPacket {
    private final BlockPos pos;
    private final ResearchMachineBlockEntity.MachineState state;
    private final String researchId;
    private final Set<ResearchType> activeTypes;
    private final float instabilityLevel;
    private final int researchTicks;

    public ResearchMachineSyncPacket(BlockPos pos, ResearchMachineBlockEntity.MachineState state, String researchId, Set<ResearchType> activeTypes, float instabilityLevel, int researchTicks) {
        this.pos = pos;
        this.state = state;
        this.researchId = researchId;
        this.activeTypes = activeTypes;
        this.instabilityLevel = instabilityLevel;
        this.researchTicks = researchTicks;
    }

    public static void encode(ResearchMachineSyncPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.m_130068_((Enum)packet.state);
        buffer.m_130070_(packet.researchId);
        buffer.writeInt(packet.activeTypes.size());
        for (ResearchType type : packet.activeTypes) {
            buffer.m_130068_((Enum)type);
        }
        buffer.writeFloat(packet.instabilityLevel);
        buffer.writeInt(packet.researchTicks);
    }

    public static ResearchMachineSyncPacket new_(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        ResearchMachineBlockEntity.MachineState state = (ResearchMachineBlockEntity.MachineState)buffer.m_130066_(ResearchMachineBlockEntity.MachineState.class);
        String researchId = buffer.m_130277_();
        int typeCount = buffer.readInt();
        HashSet<ResearchType> activeTypes = new HashSet<ResearchType>();
        for (int i = 0; i < typeCount; ++i) {
            activeTypes.add((ResearchType)buffer.m_130066_(ResearchType.class));
        }
        float instabilityLevel = buffer.readFloat();
        int researchTicks = buffer.readInt();
        return new ResearchMachineSyncPacket(pos, state, researchId, activeTypes, instabilityLevel, researchTicks);
    }

    public static void handle(ResearchMachineSyncPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getSender() != null) {
                return;
            }
            if (!context.getDirection().getReceptionSide().isClient()) {
                return;
            }
            BlockPos pos = packet.pos;
            ResearchMachineBlockEntity.MachineState state = packet.state;
            String researchId = packet.researchId;
            Set<ResearchType> activeTypes = packet.activeTypes;
            float instabilityLevel = packet.instabilityLevel;
            int researchTicks = packet.researchTicks;
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandlers.handleResearchMachineSync(pos, state, researchId, activeTypes, instabilityLevel, researchTicks));
        });
        context.setPacketHandled(true);
    }
}

