/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.network;

import com.hexvane.strangematter.client.network.ClientPacketHandlers;
import com.hexvane.strangematter.research.ResearchType;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ResearchGainPacket {
    private final ResearchType researchType;
    private final int amount;

    public ResearchGainPacket(ResearchType researchType, int amount) {
        this.researchType = researchType;
        this.amount = amount;
    }

    public ResearchGainPacket(FriendlyByteBuf buf) {
        this.researchType = ResearchType.fromName(buf.m_130277_());
        this.amount = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.researchType.getName());
        buf.writeInt(this.amount);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isClient()) {
                ResearchType finalType = this.researchType;
                int finalAmount = this.amount;
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandlers.handleResearchGain(finalType, finalAmount));
            }
        });
        context.setPacketHandled(true);
    }
}

