/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.network;

import com.hexvane.strangematter.block.ResearchMachineBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ResearchCompletionPacket {
    private final BlockPos pos;
    private final boolean success;

    public ResearchCompletionPacket(BlockPos pos, boolean success) {
        this.pos = pos;
        this.success = success;
    }

    public static void encode(ResearchCompletionPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.writeBoolean(packet.success);
    }

    public static ResearchCompletionPacket new_(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        boolean success = buffer.readBoolean();
        return new ResearchCompletionPacket(pos, success);
    }

    public static void handle(ResearchCompletionPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player;
            Level level;
            BlockEntity blockEntity;
            if (context.getSender() != null && (blockEntity = (level = (player = context.getSender()).m_9236_()).m_7702_(packet.pos)) instanceof ResearchMachineBlockEntity) {
                ResearchMachineBlockEntity researchMachine = (ResearchMachineBlockEntity)blockEntity;
                if (packet.success) {
                    researchMachine.handleResearchCompletion();
                } else {
                    researchMachine.handleResearchFailure();
                }
            }
        });
        context.setPacketHandled(true);
    }
}

