/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.network;

import com.hexvane.strangematter.client.network.ClientPacketHandlers;
import com.hexvane.strangematter.morph.PlayerMorphData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PlayerMorphSyncPacket {
    private final UUID playerUUID;
    private final String morphEntityType;
    private final UUID targetPlayerUUID;
    private final boolean clearMorph;

    public PlayerMorphSyncPacket(UUID playerUUID, String morphEntityType, UUID targetPlayerUUID, boolean clearMorph) {
        this.playerUUID = playerUUID;
        this.morphEntityType = morphEntityType;
        this.targetPlayerUUID = targetPlayerUUID;
        this.clearMorph = clearMorph;
    }

    public static void encode(PlayerMorphSyncPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.playerUUID);
        buffer.writeBoolean(packet.clearMorph);
        if (!packet.clearMorph) {
            if (packet.morphEntityType != null) {
                buffer.writeBoolean(true);
                buffer.m_130070_(packet.morphEntityType);
            } else {
                buffer.writeBoolean(false);
            }
            buffer.writeBoolean(packet.targetPlayerUUID != null);
            if (packet.targetPlayerUUID != null) {
                buffer.m_130077_(packet.targetPlayerUUID);
            }
        }
    }

    public static PlayerMorphSyncPacket decode(FriendlyByteBuf buffer) {
        UUID playerUUID = buffer.m_130259_();
        boolean clearMorph = buffer.readBoolean();
        String morphEntityType = null;
        UUID targetPlayerUUID = null;
        if (!clearMorph) {
            boolean hasTargetPlayer;
            boolean hasMorphType = buffer.readBoolean();
            if (hasMorphType) {
                morphEntityType = buffer.m_130277_();
            }
            if (hasTargetPlayer = buffer.readBoolean()) {
                targetPlayerUUID = buffer.m_130259_();
            }
        }
        return new PlayerMorphSyncPacket(playerUUID, morphEntityType, targetPlayerUUID, clearMorph);
    }

    public static void handle(PlayerMorphSyncPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                if (packet.clearMorph) {
                    System.out.println("CLIENT: Received clear morph for player " + packet.playerUUID);
                    PlayerMorphData.clearMorph(packet.playerUUID);
                    UUID finalPlayerUUID = packet.playerUUID;
                    DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandlers.cleanupMorphEntity(finalPlayerUUID));
                } else if (packet.morphEntityType != null) {
                    System.out.println("CLIENT: Received morph sync - " + packet.playerUUID + " -> " + packet.morphEntityType);
                    System.out.println("CLIENT: Current morph data before update: " + PlayerMorphData.getMorphEntityType(packet.playerUUID));
                    String oldMorph = PlayerMorphData.getMorphEntityType(packet.playerUUID);
                    if (oldMorph != null && !oldMorph.equals(packet.morphEntityType)) {
                        System.out.println("CLIENT: Clearing old morph entity cache");
                        UUID finalPlayerUUID = packet.playerUUID;
                        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandlers.cleanupMorphEntity(finalPlayerUUID));
                    }
                    PlayerMorphData.setMorph(packet.playerUUID, packet.morphEntityType, packet.targetPlayerUUID);
                    System.out.println("CLIENT: Morph data after update: " + PlayerMorphData.getMorphEntityType(packet.playerUUID));
                    if (packet.targetPlayerUUID != null) {
                        System.out.println("CLIENT: Target player UUID: " + packet.targetPlayerUUID);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("ERROR handling morph sync packet: " + e.getMessage());
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

