/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.network;

import com.hexvane.strangematter.client.network.ClientPacketHandlers;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class MobDisguiseSyncPacket {
    private final UUID mobUUID;
    private final String disguiseType;
    private final int disguiseDuration;
    private final boolean clearDisguise;

    public MobDisguiseSyncPacket(UUID mobUUID, String disguiseType, int disguiseDuration) {
        this.mobUUID = mobUUID;
        this.disguiseType = disguiseType;
        this.disguiseDuration = disguiseDuration;
        this.clearDisguise = false;
    }

    public MobDisguiseSyncPacket(UUID mobUUID) {
        this.mobUUID = mobUUID;
        this.disguiseType = "";
        this.disguiseDuration = 0;
        this.clearDisguise = true;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.mobUUID);
        buf.writeBoolean(this.clearDisguise);
        if (!this.clearDisguise) {
            buf.m_130070_(this.disguiseType);
            buf.writeInt(this.disguiseDuration);
        }
    }

    public static MobDisguiseSyncPacket decode(FriendlyByteBuf buf) {
        UUID mobUUID = buf.m_130259_();
        boolean clearDisguise = buf.readBoolean();
        if (clearDisguise) {
            return new MobDisguiseSyncPacket(mobUUID);
        }
        String disguiseType = buf.m_130277_();
        int disguiseDuration = buf.readInt();
        return new MobDisguiseSyncPacket(mobUUID, disguiseType, disguiseDuration);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (!context.getDirection().getReceptionSide().isClient()) {
                return;
            }
            UUID id = this.mobUUID;
            boolean clear = this.clearDisguise;
            String type = this.disguiseType;
            int duration = this.disguiseDuration;
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandlers.handleMobDisguiseSync(id, clear, type, duration));
        });
        context.setPacketHandled(true);
    }
}

