/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.network;

import com.hexvane.strangematter.block.ResearchMachineBlockEntity;
import com.hexvane.strangematter.research.ResearchType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class MinigameStatePacket {
    private final BlockPos pos;
    private final Map<ResearchType, Map<String, Object>> minigameStates;

    public MinigameStatePacket(BlockPos pos, Map<ResearchType, Map<String, Object>> minigameStates) {
        this.pos = pos;
        this.minigameStates = minigameStates;
    }

    public static void encode(MinigameStatePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.writeInt(packet.minigameStates.size());
        for (Map.Entry<ResearchType, Map<String, Object>> entry : packet.minigameStates.entrySet()) {
            buffer.m_130070_(entry.getKey().name());
            Map<String, Object> state = entry.getValue();
            buffer.writeInt(state.size());
            for (Map.Entry<String, Object> stateEntry : state.entrySet()) {
                buffer.m_130070_(stateEntry.getKey());
                Object value = stateEntry.getValue();
                if (value instanceof Boolean) {
                    buffer.m_130070_("boolean");
                    buffer.writeBoolean(((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof String) {
                    buffer.m_130070_("string");
                    buffer.m_130070_((String)value);
                    continue;
                }
                if (value instanceof Double) {
                    buffer.m_130070_("double");
                    buffer.writeDouble(((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Integer) {
                    buffer.m_130070_("int");
                    buffer.writeInt(((Integer)value).intValue());
                    continue;
                }
                buffer.m_130070_("string");
                buffer.m_130070_(value.toString());
            }
        }
    }

    public static MinigameStatePacket new_(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        HashMap<ResearchType, Map<String, Object>> minigameStates = new HashMap<ResearchType, Map<String, Object>>();
        int typeCount = buffer.readInt();
        for (int i = 0; i < typeCount; ++i) {
            String typeName = buffer.m_130277_();
            ResearchType type = ResearchType.valueOf(typeName);
            HashMap<String, Object> state = new HashMap<String, Object>();
            int stateCount = buffer.readInt();
            for (int j = 0; j < stateCount; ++j) {
                String valueType;
                String key = buffer.m_130277_();
                state.put(key, switch (valueType = buffer.m_130277_()) {
                    case "boolean" -> buffer.readBoolean();
                    case "string" -> buffer.m_130277_();
                    case "double" -> buffer.readDouble();
                    case "int" -> buffer.readInt();
                    default -> buffer.m_130277_();
                });
            }
            minigameStates.put(type, state);
        }
        return new MinigameStatePacket(pos, minigameStates);
    }

    public static void handle(MinigameStatePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player;
            Level level;
            BlockEntity blockEntity;
            if (context.getSender() != null && (blockEntity = (level = (player = context.getSender()).m_9236_()).m_7702_(packet.pos)) instanceof ResearchMachineBlockEntity) {
                ResearchMachineBlockEntity researchMachine = (ResearchMachineBlockEntity)blockEntity;
                researchMachine.setMinigameStates(packet.minigameStates);
            }
        });
        context.setPacketHandled(true);
    }
}

