/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.network;

import com.hexvane.strangematter.api.block.entity.IPacketHandlerTile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class MachineStatePacket {
    private final BlockPos pos;
    private final FriendlyByteBuf data;

    public MachineStatePacket(BlockPos pos, FriendlyByteBuf data) {
        this.pos = pos;
        this.data = data;
    }

    public static void encode(MachineStatePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.writeBytes((ByteBuf)packet.data);
    }

    public static MachineStatePacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        FriendlyByteBuf data = new FriendlyByteBuf(buffer.readBytes(buffer.readableBytes()));
        return new MachineStatePacket(pos, data);
    }

    public static void handle(MachineStatePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            BlockEntity blockEntity;
            Level world;
            Level level = world = context.getSender() != null ? context.getSender().m_9236_() : null;
            if (world != null && (blockEntity = world.m_7702_(packet.pos)) instanceof IPacketHandlerTile) {
                IPacketHandlerTile handlerTile = (IPacketHandlerTile)blockEntity;
                handlerTile.handleStatePacket(packet.data);
            }
        });
        context.setPacketHandled(true);
    }

    public static void sendToClient(IPacketHandlerTile tile) {
        if (tile == null || !(tile instanceof BlockEntity)) {
            return;
        }
        BlockEntity blockEntity = (BlockEntity)tile;
        if (blockEntity.m_58904_() == null || blockEntity.m_58904_().f_46443_) {
            return;
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        MachineStatePacket packet = new MachineStatePacket(blockEntity.m_58899_(), tile.getStatePacket(buffer));
    }
}

