/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.network;

import com.hexvane.strangematter.entity.HoverboardEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class HoverboardJumpPacket {
    private final int entityId;

    public HoverboardJumpPacket(int entityId) {
        this.entityId = entityId;
    }

    public HoverboardJumpPacket(FriendlyByteBuf buffer) {
        this.entityId = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            HoverboardEntity hoverboard;
            Level level;
            Entity entity;
            if (context.getSender() != null && (entity = (level = context.getSender().m_9236_()).m_6815_(this.entityId)) instanceof HoverboardEntity && (hoverboard = (HoverboardEntity)entity).m_20160_()) {
                LivingEntity controllingPassenger = hoverboard.m_6688_();
                if (controllingPassenger == null && !hoverboard.m_20197_().isEmpty()) {
                    controllingPassenger = (Entity)hoverboard.m_20197_().get(0);
                }
                if (controllingPassenger != null && controllingPassenger.m_19879_() == context.getSender().m_19879_()) {
                    hoverboard.setJumpPressed(true);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

