/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.network;

import com.hexvane.strangematter.client.network.ClientPacketHandlers;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class GravitySyncPacket {
    private final double gravityForce;

    public GravitySyncPacket(double gravityForce) {
        this.gravityForce = gravityForce;
    }

    public GravitySyncPacket(FriendlyByteBuf buffer) {
        this.gravityForce = buffer.readDouble();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.gravityForce);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getSender() != null) {
                context.getSender().getPersistentData().m_128347_("strangematter.gravity_force", this.gravityForce);
                return;
            }
            if (context.getDirection().getReceptionSide().isClient()) {
                double force = this.gravityForce;
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandlers.handleGravitySync(force));
            }
        });
        context.setPacketHandled(true);
    }

    public double getGravityForce() {
        return this.gravityForce;
    }
}

