/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.network;

import com.hexvane.strangematter.client.network.ClientPacketHandlers;
import com.hexvane.strangematter.network.NetworkHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class EchoVacuumBeamPacket {
    private final int playerId;
    private final boolean isActive;

    public EchoVacuumBeamPacket(int playerId, boolean isActive) {
        this.playerId = playerId;
        this.isActive = isActive;
    }

    public EchoVacuumBeamPacket(FriendlyByteBuf buffer) {
        this.playerId = buffer.readInt();
        this.isActive = buffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.playerId);
        buffer.writeBoolean(this.isActive);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (!((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isClient()) {
                return;
            }
            int id = this.playerId;
            boolean active = this.isActive;
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandlers.handleEchoVacuumBeam(id, active));
        });
        return true;
    }

    public static void sendToNearbyPlayers(Player sourcePlayer, boolean isActive) {
        Level level = sourcePlayer.m_9236_();
        if (!level.f_46443_) {
            EchoVacuumBeamPacket packet = new EchoVacuumBeamPacket(sourcePlayer.m_19879_(), isActive);
            NetworkHandler.INSTANCE.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)sourcePlayer.m_20185_(), (double)sourcePlayer.m_20186_(), (double)sourcePlayer.m_20189_(), (double)64.0, (ResourceKey)level.m_46472_())), (Object)packet);
        }
    }
}

