/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.morph;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class PlayerMorphData {
    private static final Map<UUID, String> morphedEntities = new HashMap<UUID, String>();
    private static final Map<UUID, UUID> morphedPlayerUUIDs = new HashMap<UUID, UUID>();

    public static void setMorph(UUID playerUUID, String entityTypeId) {
        PlayerMorphData.setMorph(playerUUID, entityTypeId, null);
    }

    public static void setMorph(UUID playerUUID, String entityTypeId, UUID targetPlayerUUID) {
        morphedEntities.put(playerUUID, entityTypeId);
        if (targetPlayerUUID != null) {
            morphedPlayerUUIDs.put(playerUUID, targetPlayerUUID);
        } else {
            morphedPlayerUUIDs.remove(playerUUID);
        }
    }

    public static void clearMorph(UUID playerUUID) {
        morphedEntities.remove(playerUUID);
        morphedPlayerUUIDs.remove(playerUUID);
    }

    public static UUID getMorphedPlayerUUID(UUID playerUUID) {
        return morphedPlayerUUIDs.get(playerUUID);
    }

    public static boolean isMorphed(UUID playerUUID) {
        return morphedEntities.containsKey(playerUUID);
    }

    public static String getMorphEntityType(UUID playerUUID) {
        return morphedEntities.get(playerUUID);
    }

    public static EntityType<?> getMorphEntityTypeObj(UUID playerUUID) {
        String entityTypeId = morphedEntities.get(playerUUID);
        if (entityTypeId == null) {
            return null;
        }
        try {
            ResourceLocation resourceLocation = ResourceLocation.parse((String)entityTypeId);
            return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(resourceLocation);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CompoundTag save(CompoundTag tag) {
        CompoundTag morphsTag = new CompoundTag();
        for (Map.Entry<UUID, String> entry : morphedEntities.entrySet()) {
            morphsTag.m_128359_(entry.getKey().toString(), entry.getValue());
        }
        tag.m_128365_("morphs", (Tag)morphsTag);
        return tag;
    }

    public static void load(CompoundTag tag) {
        morphedEntities.clear();
        if (tag.m_128441_("morphs")) {
            CompoundTag morphsTag = tag.m_128469_("morphs");
            for (String key : morphsTag.m_128431_()) {
                try {
                    UUID uuid = UUID.fromString(key);
                    morphedEntities.put(uuid, morphsTag.m_128461_(key));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }
}

