/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.mixin;

import com.hexvane.strangematter.client.PlayerMorphRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public class PlayerRendererMixin {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderPlayer(AbstractClientPlayer player, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        try {
            EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
            boolean renderedAsMorph = PlayerMorphRenderer.renderPlayerAsMorph((Player)player, dispatcher, poseStack, buffer, packedLight, partialTicks);
            if (renderedAsMorph) {
                ci.cancel();
            }
        }
        catch (NoClassDefFoundError e) {
            LOGGER.warn("Failed to load morph renderer classes, falling back to normal rendering: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("Error in morph rendering, falling back to normal rendering", (Throwable)e);
        }
    }
}

