/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.menu;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.block.RealityForgeBlockEntity;
import com.hexvane.strangematter.menu.BaseMachineMenu;
import com.hexvane.strangematter.menu.slots.OutputSlot;
import com.hexvane.strangematter.menu.slots.ShardSlot;
import com.hexvane.strangematter.network.EjectShardsPacket;
import com.hexvane.strangematter.network.NetworkHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RealityForgeMenu
extends BaseMachineMenu {
    private final RealityForgeBlockEntity blockEntity;
    private final ContainerLevelAccess levelAccess;
    private final ContainerData dataAccess;

    public RealityForgeMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, data.m_130135_());
    }

    public RealityForgeMenu(int windowId, Inventory playerInventory, BlockPos pos) {
        super((MenuType)StrangeMatterMod.REALITY_FORGE_MENU.get(), windowId, playerInventory, (blockEntity = playerInventory.f_35978_.m_9236_().m_7702_(pos)) instanceof RealityForgeBlockEntity ? (be = (RealityForgeBlockEntity)blockEntity) : null, 11);
        RealityForgeBlockEntity be;
        BlockEntity blockEntity;
        blockEntity = playerInventory.f_35978_.m_9236_().m_7702_(pos);
        this.blockEntity = blockEntity instanceof RealityForgeBlockEntity ? (be = (RealityForgeBlockEntity)blockEntity) : null;
        this.levelAccess = ContainerLevelAccess.m_39289_((Level)playerInventory.f_35978_.m_9236_(), (BlockPos)pos);
        ContainerData containerData = this.dataAccess = this.blockEntity != null ? this.blockEntity.getDataAccess() : null;
        if (this.blockEntity != null) {
            this.blockEntity.setCurrentPlayer(playerInventory.f_35978_);
        }
        if (this.dataAccess != null) {
            this.m_38884_(this.dataAccess);
        }
    }

    public RealityForgeMenu(int windowId, Inventory playerInventory) {
        super((MenuType)StrangeMatterMod.REALITY_FORGE_MENU.get(), windowId, playerInventory, 11);
        this.blockEntity = null;
        this.levelAccess = ContainerLevelAccess.f_39287_;
        this.dataAccess = null;
    }

    public RealityForgeMenu(int windowId, Inventory playerInventory, RealityForgeBlockEntity blockEntity) {
        super((MenuType)StrangeMatterMod.REALITY_FORGE_MENU.get(), windowId, playerInventory, blockEntity, 11);
        this.blockEntity = blockEntity;
        this.levelAccess = ContainerLevelAccess.m_39289_((Level)playerInventory.f_35978_.m_9236_(), (BlockPos)(blockEntity != null ? blockEntity.m_58899_() : BlockPos.f_121853_));
        ContainerData containerData = this.dataAccess = this.blockEntity != null ? this.blockEntity.getDataAccess() : null;
        if (this.dataAccess != null) {
            this.m_38884_(this.dataAccess);
        }
    }

    @Override
    protected void addMachineSlots() {
        if (this.blockEntity != null) {
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    int containerSlot = row * 3 + col;
                    int menuSlot = this.f_38839_.size();
                    this.m_38897_(new Slot((Container)this.blockEntity, containerSlot, 64 + col * 16, 13 + row * 16));
                }
            }
            int shardMenuSlot = this.f_38839_.size();
            this.m_38897_(new ShardSlot(this.blockEntity, 9, 37, 27));
            int outputMenuSlot = this.f_38839_.size();
            this.m_38897_(new OutputSlot(this.blockEntity, 10, 122, 29));
        } else if (this.machineInventory != null) {
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    int containerSlot = row * 3 + col;
                    int menuSlot = this.f_38839_.size();
                    this.m_38897_(new Slot(this.machineInventory, containerSlot, 64 + col * 16, 13 + row * 16));
                }
            }
            int shardMenuSlot = this.f_38839_.size();
            this.m_38897_(new ShardSlot(this.machineInventory, 9, 37, 27));
            int outputMenuSlot = this.f_38839_.size();
            this.m_38897_(new OutputSlot(this.machineInventory, 10, 122, 29));
        } else {
            Container dummyContainer = new Container(){
                private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)11, (Object)ItemStack.f_41583_);

                public int m_6643_() {
                    return 11;
                }

                public boolean m_7983_() {
                    return this.items.stream().allMatch(ItemStack::m_41619_);
                }

                public ItemStack m_8020_(int index) {
                    return (ItemStack)this.items.get(index);
                }

                public ItemStack m_7407_(int index, int count) {
                    return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
                }

                public ItemStack m_8016_(int index) {
                    return ContainerHelper.m_18966_(this.items, (int)index);
                }

                public void m_6836_(int index, ItemStack stack) {
                    this.items.set(index, (Object)stack);
                }

                public void m_6596_() {
                }

                public boolean m_6542_(Player player) {
                    return false;
                }

                public void m_6211_() {
                    this.items.clear();
                }
            };
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    this.m_38897_(new Slot(dummyContainer, row * 3 + col, 64 + col * 16, 13 + row * 16));
                }
            }
            this.m_38897_(new ShardSlot(dummyContainer, 9, 37, 27));
            this.m_38897_(new OutputSlot(dummyContainer, 10, 122, 29));
        }
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        if (this.isCrafting() && index >= 0 && index < 11) {
            return ItemStack.f_41583_;
        }
        ItemStack result = super.m_7648_(player, index);
        return result;
    }

    public void m_150399_(int slotIndex, int button, ClickType clickType, Player player) {
        if (this.isCrafting() && slotIndex >= 0 && slotIndex < 11) {
            return;
        }
        super.m_150399_(slotIndex, button, clickType, player);
    }

    public RealityForgeBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public void ejectShards() {
        if (this.isCrafting()) {
            return;
        }
        if (this.blockEntity != null) {
            NetworkHandler.INSTANCE.sendToServer((Object)new EjectShardsPacket(this.blockEntity.m_58899_()));
        }
    }

    public void attemptCraft() {
        if (this.blockEntity != null) {
            this.blockEntity.attemptCraft();
        }
    }

    public boolean isCrafting() {
        if (this.blockEntity != null) {
            return this.blockEntity.isCrafting();
        }
        return false;
    }

    public boolean isCoalescing() {
        if (this.blockEntity != null) {
            return this.blockEntity.isCoalescing();
        }
        return false;
    }

    public int getCraftProgress() {
        if (this.blockEntity != null) {
            return this.blockEntity.getCraftProgress();
        }
        return 0;
    }

    public int getCoalesceProgress() {
        if (this.blockEntity != null) {
            return this.blockEntity.getCoalesceProgress();
        }
        return 0;
    }

    public Map<String, Integer> getStoredShards() {
        if (this.blockEntity != null) {
            return this.blockEntity.getStoredShards();
        }
        return new HashMap<String, Integer>();
    }

    public List<String> getShardOrder() {
        if (this.blockEntity != null) {
            return this.blockEntity.getShardOrder();
        }
        return new ArrayList<String>();
    }

    public ContainerData getDataAccess() {
        return this.dataAccess;
    }

    @Override
    protected void addPlayerSlots(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int containerSlot = col + row * 9 + 9;
                int menuSlot = this.f_38839_.size();
                this.m_38897_(new Slot((Container)playerInventory, containerSlot, 9 + col * 18, 68 + row * 17));
            }
        }
        for (int col = 0; col < 9; ++col) {
            int containerSlot = col;
            this.m_38897_(new Slot((Container)playerInventory, containerSlot, 9 + col * 18, 124));
        }
    }
}

