/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.menu;

import com.hexvane.strangematter.api.block.entity.IPacketHandlerTile;
import com.hexvane.strangematter.block.BaseMachineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class BaseMachineMenu
extends AbstractContainerMenu {
    protected final Container machineInventory;
    protected final ContainerLevelAccess levelAccess;
    protected final int machineSlotCount;
    protected final Player player;

    public BaseMachineMenu(MenuType<?> menuType, int id, Inventory playerInventory, Container machineInventory, int machineSlotCount) {
        super(menuType, id);
        BlockPos blockPos;
        Level level;
        BlockEntity blockEntity;
        this.machineInventory = machineInventory;
        this.machineSlotCount = machineSlotCount;
        this.player = playerInventory.f_35978_;
        if (machineInventory instanceof BlockEntity) {
            blockEntity = (BlockEntity)machineInventory;
            level = blockEntity.m_58904_();
        } else {
            level = null;
        }
        if (machineInventory instanceof BlockEntity) {
            blockEntity = (BlockEntity)machineInventory;
            blockPos = blockEntity.m_58899_();
        } else {
            blockPos = BlockPos.f_121853_;
        }
        this.levelAccess = ContainerLevelAccess.m_39289_((Level)level, (BlockPos)blockPos);
        this.addMachineSlots();
        this.addPlayerSlots(playerInventory);
    }

    public BaseMachineMenu(MenuType<?> menuType, int id, Inventory playerInventory, int machineSlotCount) {
        super(menuType, id);
        this.machineInventory = null;
        this.machineSlotCount = machineSlotCount;
        this.player = playerInventory.f_35978_;
        this.levelAccess = ContainerLevelAccess.f_39287_;
        this.addMachineSlots();
        this.addPlayerSlots(playerInventory);
    }

    protected abstract void addMachineSlots();

    protected void addPlayerSlots(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 51 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 109));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.machineSlotCount ? !this.m_38903_(itemstack1, this.machineSlotCount, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.machineSlotCount, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        if (this.machineInventory == null) {
            return false;
        }
        return (Boolean)this.levelAccess.m_39299_((level, pos) -> level.m_7702_(pos) == this.machineInventory && player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    public Container getMachineInventory() {
        return this.machineInventory;
    }

    public int getMachineSlotCount() {
        return this.machineSlotCount;
    }

    public void m_38946_() {
        IPacketHandlerTile packetHandler;
        Container container;
        super.m_38946_();
        if (this.machineInventory != null && (container = this.machineInventory) instanceof IPacketHandlerTile && (packetHandler = (IPacketHandlerTile)container) instanceof BaseMachineBlockEntity) {
            BaseMachineBlockEntity machineEntity = (BaseMachineBlockEntity)packetHandler;
            machineEntity.sendStatePacket();
        }
    }
}

