/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.kubejs;

import com.hexvane.strangematter.kubejs.CustomResearchRegistry;
import com.hexvane.strangematter.kubejs.ResearchInfoPage;
import com.hexvane.strangematter.kubejs.ResearchInfoPageBuilder;
import com.hexvane.strangematter.kubejs.ResearchNodeBuilder;
import com.hexvane.strangematter.research.ResearchNode;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class StrangeMatterHelper {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static ResearchNodeBuilder createResearchNode(String id) {
        return new ResearchNodeBuilder(id);
    }

    public static void registerNode(ResearchNodeBuilder builder) {
        ResearchNode node = builder.build();
        CustomResearchRegistry.registerNode(node);
    }

    public static ResearchInfoPageBuilder createInfoPage() {
        return new ResearchInfoPageBuilder();
    }

    public static void registerInfoPages(String nodeId, List<ResearchInfoPage> pages) {
        CustomResearchRegistry.registerInfoPages(nodeId, pages);
    }

    public static void registerInfoPage(String nodeId, ResearchInfoPage page) {
        LOGGER.info("[Strange Matter KubeJS] registerInfoPage called for {}", (Object)nodeId);
        ArrayList<ResearchInfoPage> pages = new ArrayList<ResearchInfoPage>();
        pages.add(page);
        CustomResearchRegistry.registerInfoPages(nodeId, pages);
    }

    public static void addSimplePage(String nodeId, String title, String content) {
        LOGGER.info("[Strange Matter KubeJS] addSimplePage called for {}: {}", (Object)nodeId, (Object)title);
        ResearchInfoPage page = new ResearchInfoPage();
        page.title = title;
        page.content = content;
        page.hasRecipes = false;
        page.hasScreenshots = false;
        page.recipeName = null;
        page.isRealityForgeRecipe = false;
        page.screenshotPath = null;
        LOGGER.info("[Strange Matter KubeJS] Created page object: {}", (Object)page.title);
        List<ResearchInfoPage> existingPages = CustomResearchRegistry.getInfoPages(nodeId);
        ArrayList<ResearchInfoPage> allPages = existingPages != null ? new ArrayList<ResearchInfoPage>(existingPages) : new ArrayList();
        allPages.add(page);
        LOGGER.info("[Strange Matter KubeJS] Registering {} total pages for {}", (Object)allPages.size(), (Object)nodeId);
        CustomResearchRegistry.registerInfoPages(nodeId, allPages);
    }

    public static void addRecipePage(String nodeId, String title, String content, String recipeName) {
        LOGGER.info("[Strange Matter KubeJS] addRecipePage called for {}", (Object)nodeId);
        ResearchInfoPage page = new ResearchInfoPage();
        page.title = title;
        page.content = content;
        page.hasRecipes = true;
        page.hasScreenshots = false;
        page.recipeName = recipeName;
        page.isRealityForgeRecipe = false;
        page.screenshotPath = null;
        List<ResearchInfoPage> existingPages = CustomResearchRegistry.getInfoPages(nodeId);
        ArrayList<ResearchInfoPage> allPages = existingPages != null ? new ArrayList<ResearchInfoPage>(existingPages) : new ArrayList();
        allPages.add(page);
        LOGGER.info("[Strange Matter KubeJS] Registering {} total pages for {}", (Object)allPages.size(), (Object)nodeId);
        CustomResearchRegistry.registerInfoPages(nodeId, allPages);
    }

    public static InfoPagesBuilder createInfoPagesBuilder(String nodeId) {
        LOGGER.info("[Strange Matter KubeJS] Created info pages builder for: {}", (Object)nodeId);
        return new InfoPagesBuilder(nodeId);
    }

    public static void addInfoPages(String nodeId, Consumer<InfoPagesBuilder> consumer) {
        LOGGER.info("[Strange Matter KubeJS] addInfoPages called for: {}", (Object)nodeId);
        InfoPagesBuilder builder = new InfoPagesBuilder(nodeId);
        consumer.accept(builder);
        builder.finish();
    }

    public static Class<CustomResearchRegistry> getRegistry() {
        return CustomResearchRegistry.class;
    }

    public static class InfoPagesBuilder {
        private final List<ResearchInfoPage> pages = new ArrayList<ResearchInfoPage>();
        private final String nodeId;

        public InfoPagesBuilder(String nodeId) {
            this.nodeId = nodeId;
        }

        public CustomResearchInfoPageBuilder page() {
            return new CustomResearchInfoPageBuilder(this);
        }

        void addPage(ResearchInfoPage page) {
            this.pages.add(page);
            LOGGER.info("[Strange Matter KubeJS] Added page: {}", (Object)page.title);
        }

        public void finish() {
            LOGGER.info("[Strange Matter KubeJS] Finishing builder with {} pages", (Object)this.pages.size());
            CustomResearchRegistry.registerInfoPages(this.nodeId, this.pages);
        }

        List<ResearchInfoPage> build() {
            return this.pages;
        }
    }

    public static class CustomResearchInfoPageBuilder
    extends ResearchInfoPageBuilder {
        private final InfoPagesBuilder parent;

        CustomResearchInfoPageBuilder(InfoPagesBuilder parent) {
            this.parent = parent;
        }

        @Override
        public ResearchInfoPageBuilder title(String title) {
            super.title(title);
            return this;
        }

        @Override
        public ResearchInfoPageBuilder content(String content) {
            super.content(content);
            return this;
        }

        @Override
        public ResearchInfoPageBuilder recipe(String recipeName) {
            super.recipe(recipeName);
            return this;
        }

        @Override
        public ResearchInfoPageBuilder realityForgeRecipe(String recipeName) {
            super.realityForgeRecipe(recipeName);
            return this;
        }

        @Override
        public ResearchInfoPageBuilder screenshot(String screenshotPath) {
            super.screenshot(screenshotPath);
            return this;
        }

        @Override
        public ResearchInfoPage build() {
            ResearchInfoPage page = super.build();
            this.parent.addPage(page);
            return page;
        }
    }
}

