/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.kubejs;

import com.hexvane.strangematter.research.ResearchNode;
import com.hexvane.strangematter.research.ResearchType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ResearchNodeBuilder {
    private String id;
    private String category = "custom";
    private int x = 0;
    private int y = 0;
    private Map<ResearchType, Integer> researchCosts = new HashMap<ResearchType, Integer>();
    private ResourceLocation iconTexture = null;
    private ItemStack iconItem = ItemStack.f_41583_;
    private boolean requiresMultipleAspects = false;
    private List<String> prerequisites = new ArrayList<String>();

    public ResearchNodeBuilder(String id) {
        this.id = id;
    }

    public ResearchNodeBuilder category(String category) {
        this.category = category;
        return this;
    }

    public ResearchNodeBuilder x(int x) {
        this.x = x;
        return this;
    }

    public ResearchNodeBuilder y(int y) {
        this.y = y;
        return this;
    }

    public ResearchNodeBuilder position(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public ResearchNodeBuilder cost(String typeName, int amount) {
        ResearchType type = ResearchType.fromName(typeName);
        if (type != null && amount > 0) {
            this.researchCosts.put(type, amount);
        }
        return this;
    }

    public ResearchNodeBuilder costs(Map<String, Integer> costs) {
        for (Map.Entry<String, Integer> entry : costs.entrySet()) {
            this.cost(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ResearchNodeBuilder iconTexture(String texturePath) {
        this.iconTexture = ResourceLocation.parse((String)texturePath);
        return this;
    }

    public ResearchNodeBuilder iconItem(String itemId) {
        try {
            ResourceLocation itemLocation = ResourceLocation.parse((String)itemId);
            BuiltInRegistries.f_257033_.m_6612_(itemLocation).ifPresent(item -> {
                this.iconItem = new ItemStack((ItemLike)item);
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public ResearchNodeBuilder requiresMultipleAspects(boolean requires) {
        this.requiresMultipleAspects = requires;
        return this;
    }

    public ResearchNodeBuilder prerequisite(String prerequisiteId) {
        if (!this.prerequisites.contains(prerequisiteId)) {
            this.prerequisites.add(prerequisiteId);
        }
        return this;
    }

    public ResearchNodeBuilder prerequisites(List<String> prerequisiteIds) {
        for (String prereq : prerequisiteIds) {
            this.prerequisite(prereq);
        }
        return this;
    }

    public ResearchNode build() {
        if (this.id == null || this.id.isEmpty()) {
            throw new IllegalStateException("Research node ID cannot be null or empty");
        }
        if (this.iconTexture == null && (this.iconItem == null || this.iconItem.m_41619_())) {
            this.iconTexture = ResourceLocation.parse((String)"strangematter:textures/ui/research_gui_node.png");
        }
        return new ResearchNode(this.id, this.category, this.x, this.y, new HashMap<ResearchType, Integer>(this.researchCosts), this.iconTexture, this.iconItem.m_41777_(), this.requiresMultipleAspects, new ArrayList<String>(this.prerequisites));
    }

    public String getId() {
        return this.id;
    }
}

