/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.kubejs;

import com.hexvane.strangematter.kubejs.ResearchInfoPage;

public class ResearchInfoPageBuilder {
    private String title;
    private String content;
    private boolean hasRecipes = false;
    private boolean hasScreenshots = false;
    private String recipeName = null;
    private boolean isRealityForgeRecipe = false;
    private String screenshotPath = null;

    public ResearchInfoPageBuilder title(String title) {
        this.title = title;
        return this;
    }

    public ResearchInfoPageBuilder content(String content) {
        this.content = content;
        return this;
    }

    public ResearchInfoPageBuilder recipe(String recipeName) {
        this.hasRecipes = true;
        this.recipeName = recipeName;
        return this;
    }

    public ResearchInfoPageBuilder realityForgeRecipe(String recipeName) {
        this.hasRecipes = true;
        this.recipeName = recipeName;
        this.isRealityForgeRecipe = true;
        return this;
    }

    public ResearchInfoPageBuilder screenshot(String screenshotPath) {
        this.hasScreenshots = true;
        this.screenshotPath = screenshotPath;
        return this;
    }

    public ResearchInfoPage build() {
        if (this.title == null || this.title.isEmpty()) {
            throw new IllegalStateException("Info page must have a title");
        }
        ResearchInfoPage page = new ResearchInfoPage();
        page.title = this.title;
        page.content = this.content != null ? this.content : "";
        page.hasRecipes = this.hasRecipes;
        page.hasScreenshots = this.hasScreenshots;
        page.recipeName = this.recipeName;
        page.isRealityForgeRecipe = this.isRealityForgeRecipe;
        page.screenshotPath = this.screenshotPath;
        return page;
    }
}

