/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.kubejs;

import com.hexvane.strangematter.kubejs.ResearchInfoPage;
import com.hexvane.strangematter.research.ResearchNode;
import com.hexvane.strangematter.research.ResearchNodeRegistry;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class CustomResearchRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, List<ResearchInfoPage>> customPages = new HashMap<String, List<ResearchInfoPage>>();
    private static final List<ResearchNode> customNodes = new ArrayList<ResearchNode>();
    private static final List<ResearchNode> permanentCustomNodes = new ArrayList<ResearchNode>();
    private static final Map<String, List<ResearchInfoPage>> permanentCustomPages = new HashMap<String, List<ResearchInfoPage>>();
    private static boolean initialized = false;

    public static void registerNode(ResearchNode node) {
        if (!permanentCustomNodes.contains(node)) {
            permanentCustomNodes.add(node);
        }
        if (!initialized) {
            customNodes.add(node);
        }
    }

    public static void registerInfoPages(String nodeId, List<ResearchInfoPage> pages) {
        LOGGER.info("[Strange Matter KubeJS] registerInfoPages called for {} with {} pages", (Object)nodeId, (Object)(pages != null ? pages.size() : 0));
        if (!initialized) {
            customPages.put(nodeId, new ArrayList<ResearchInfoPage>(pages));
            permanentCustomPages.put(nodeId, new ArrayList<ResearchInfoPage>(pages));
            LOGGER.info("[Strange Matter KubeJS] Registered {} pages for {}", (Object)pages.size(), (Object)nodeId);
        } else {
            LOGGER.warn("[Strange Matter KubeJS] Cannot register pages - already initialized!");
        }
    }

    public static List<ResearchInfoPage> getInfoPages(String nodeId) {
        return permanentCustomPages.get(nodeId);
    }

    public static boolean hasCustomPages(String nodeId) {
        return permanentCustomPages.containsKey(nodeId);
    }

    public static List<ResearchNode> getCustomNodes() {
        return new ArrayList<ResearchNode>(customNodes);
    }

    public static void initializeCustomResearch() {
        for (ResearchNode node : permanentCustomNodes) {
            ResearchNodeRegistry.register(node);
        }
        initialized = true;
        LOGGER.info("[Strange Matter KubeJS] Initialized {} custom research nodes", (Object)permanentCustomNodes.size());
    }

    public static void reset() {
        customPages.clear();
        customNodes.clear();
        initialized = false;
        LOGGER.info("[Strange Matter KubeJS] Reset custom research registry (keeping {} permanent nodes and {} page sets)", (Object)permanentCustomNodes.size(), (Object)permanentCustomPages.size());
    }

    public static boolean isInitialized() {
        return initialized;
    }
}

