/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.jei.categories;

import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.jei.recipes.RealityForgeRecipe;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class RealityForgeCategory
implements IRecipeCategory<RealityForgeRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"reality_forge");
    public static final RecipeType<RealityForgeRecipe> RECIPE_TYPE = RecipeType.create((String)"strangematter", (String)"reality_forge", RealityForgeRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"textures/gui/jei/reality_forge_recipe_background.png");

    public RealityForgeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(BACKGROUND_TEXTURE, 0, 0, 200, 92);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)StrangeMatterMod.REALITY_FORGE_BLOCK.get()));
    }

    public RecipeType<RealityForgeRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.strangematter.reality_forge");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RealityForgeRecipe recipe, IFocusGroup focuses) {
        List<Ingredient> inputs = recipe.getInputs();
        System.out.println("JEI Category: Recipe has " + inputs.size() + " inputs");
        if (inputs.isEmpty()) {
            System.out.println("ERROR: Recipe has no inputs, cannot display in JEI");
            return;
        }
        while (inputs.size() < 9) {
            inputs.add(Ingredient.f_43901_);
        }
        int gridStartX = 92;
        int gridStartY = 20;
        builder.addSlot(RecipeIngredientRole.INPUT, gridStartX, gridStartY).addIngredients(inputs.get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, gridStartX + 18, gridStartY).addIngredients(inputs.get(1));
        builder.addSlot(RecipeIngredientRole.INPUT, gridStartX + 36, gridStartY).addIngredients(inputs.get(2));
        builder.addSlot(RecipeIngredientRole.INPUT, gridStartX, gridStartY + 18).addIngredients(inputs.get(3));
        builder.addSlot(RecipeIngredientRole.INPUT, gridStartX + 18, gridStartY + 18).addIngredients(inputs.get(4));
        builder.addSlot(RecipeIngredientRole.INPUT, gridStartX + 36, gridStartY + 18).addIngredients(inputs.get(5));
        builder.addSlot(RecipeIngredientRole.INPUT, gridStartX, gridStartY + 36).addIngredients(inputs.get(6));
        builder.addSlot(RecipeIngredientRole.INPUT, gridStartX + 18, gridStartY + 36).addIngredients(inputs.get(7));
        builder.addSlot(RecipeIngredientRole.INPUT, gridStartX + 36, gridStartY + 36).addIngredients(inputs.get(8));
        int shardIndex = 0;
        for (Map.Entry<String, Integer> shardEntry : recipe.getShardInputs().entrySet()) {
            String shardType = shardEntry.getKey();
            int shardCount = shardEntry.getValue();
            Ingredient shardIngredient = switch (shardType) {
                case "spatial" -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)StrangeMatterMod.SPATIAL_SHARD.get()});
                case "energetic" -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)StrangeMatterMod.ENERGETIC_SHARD.get()});
                case "gravitic" -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)StrangeMatterMod.GRAVITIC_SHARD.get()});
                case "chrono" -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)StrangeMatterMod.CHRONO_SHARD.get()});
                case "shade" -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)StrangeMatterMod.SHADE_SHARD.get()});
                case "insight" -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)StrangeMatterMod.INSIGHT_SHARD.get()});
                default -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)StrangeMatterMod.ENERGETIC_SHARD.get()});
            };
            int shardSlotX = shardIndex < 3 ? 20 : 50;
            int shardSlotY = 20 + shardIndex % 3 * 18;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, shardSlotX, shardSlotY).addIngredients(shardIngredient)).setSlotName("shard_" + shardType);
            ++shardIndex;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 172, 38).addItemStack(recipe.getOutput());
    }

    public void draw(RealityForgeRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int shardIndex = 0;
        for (Map.Entry<String, Integer> shardEntry : recipe.getShardInputs().entrySet()) {
            int shardCount = shardEntry.getValue();
            int shardSlotX = shardIndex < 3 ? 20 : 50;
            int shardSlotY = 20 + shardIndex % 3 * 18;
            String quantityText = shardCount + "x";
            int textX = shardSlotX - 12;
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, quantityText, textX, shardSlotY + 4, 0xFFFFFF);
            ++shardIndex;
        }
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }
}

