/*
 * Decompiled with CFR 0.152.
 */
package com.hexvane.strangematter.jei;

import com.hexvane.strangematter.Config;
import com.hexvane.strangematter.StrangeMatterMod;
import com.hexvane.strangematter.jei.categories.RealityForgeCategory;
import com.hexvane.strangematter.jei.recipes.RealityForgeRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

@JeiPlugin
public class StrangeMatterJeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"strangematter", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            registration.addRecipeCategories(new IRecipeCategory[]{new RealityForgeCategory(registration.getJeiHelpers().getGuiHelper())});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (FMLEnvironment.dist != Dist.CLIENT) {
            return;
        }
        if (Config.hideRecipesInRecipeViewers) {
            this.addInfoPages(registration);
            return;
        }
        List<RealityForgeRecipe> recipes = this.loadRealityForgeRecipes(registration);
        if (!recipes.isEmpty()) {
            registration.addRecipes(RealityForgeCategory.RECIPE_TYPE, recipes);
        }
        this.addInfoPages(registration);
    }

    private List<RealityForgeRecipe> loadRealityForgeRecipes(IRecipeRegistration registration) {
        ArrayList<RealityForgeRecipe> recipes = new ArrayList<RealityForgeRecipe>();
        try {
            Level level = this.getClientLevel();
            if (level == null) {
                System.out.println("Level is null, cannot load recipes yet");
                return recipes;
            }
            RecipeManager recipeManager = level.m_7465_();
            if (recipeManager == null) {
                System.out.println("Recipe manager is null, cannot load recipes yet");
                return recipes;
            }
            RecipeType recipeType = (RecipeType)StrangeMatterMod.REALITY_FORGE_RECIPE_TYPE.get();
            if (recipeType == null) {
                return recipes;
            }
            List realityForgeRecipes = recipeManager.m_44013_(recipeType);
            for (com.hexvane.strangematter.recipe.RealityForgeRecipe recipe : realityForgeRecipes) {
                RealityForgeRecipe jeiRecipe = this.convertToJeiRecipe(recipe, level);
                if (jeiRecipe == null) continue;
                recipes.add(jeiRecipe);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load reality forge recipes: " + e.getMessage());
            e.printStackTrace();
        }
        return recipes;
    }

    private Level getClientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }

    private RealityForgeRecipe convertToJeiRecipe(com.hexvane.strangematter.recipe.RealityForgeRecipe recipe, Level level) {
        try {
            NonNullList<Ingredient> ingredients = recipe.m_7527_();
            Map<String, Integer> shardInputs = recipe.getShardRequirements();
            ItemStack resultStack = recipe.m_8043_(level.m_9598_());
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>((Collection<Ingredient>)ingredients);
            return new RealityForgeRecipe(inputs, resultStack, shardInputs);
        }
        catch (Exception e) {
            System.err.println("Failed to convert recipe " + recipe.m_6423_() + " to JEI format: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private void addInfoPages(IRecipeRegistration registration) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)StrangeMatterMod.REALITY_FORGE_ITEM.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.strangematter.reality_forge.info")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)StrangeMatterMod.RESONANCE_CONDENSER_ITEM.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.strangematter.resonance_condenser.info")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)StrangeMatterMod.RESEARCH_NOTES.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.strangematter.research_notes.info")});
    }
}

